/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInboundHandlerAdapter;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.haproxy.HAProxyMessage;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.AddressUtils;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

final class HAProxyMessageReader
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<InetSocketAddress> REMOTE_ADDRESS_FROM_PROXY_PROTOCOL = AttributeKey.valueOf("remoteAddressFromProxyProtocol");
    private static final boolean isProxyProtocolAvailable;

    HAProxyMessageReader() {
    }

    static boolean isProxyProtocolAvailable() {
        return isProxyProtocolAvailable;
    }

    @Nullable
    static SocketAddress resolveRemoteAddressFromProxyProtocol(Channel channel) {
        if (HAProxyMessageReader.isProxyProtocolAvailable()) {
            return channel.attr(REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).getAndSet(null);
        }
        return null;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage proxyMessage = (HAProxyMessage)msg;
            if (proxyMessage.sourceAddress() != null && proxyMessage.sourcePort() != 0) {
                InetSocketAddress remoteAddress = AddressUtils.createUnresolved(proxyMessage.sourceAddress(), proxyMessage.sourcePort());
                ctx.channel().attr(REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).set(remoteAddress);
            }
            proxyMessage.release();
            ctx.channel().pipeline().remove(this);
            ctx.read();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    static {
        boolean proxyProtocolCheck = true;
        try {
            Class.forName("com.dataiku.dss.shadelibazure.io.netty.handler.codec.haproxy.HAProxyMessageDecoder");
        }
        catch (ClassNotFoundException cnfe) {
            proxyProtocolCheck = false;
        }
        isProxyProtocolAvailable = proxyProtocolCheck;
    }
}

