/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.util.AbstractConstant;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.DisposableServer;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServer;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.TcpServerConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ServerTransport;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.Transport;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

final class HttpServerBind
extends HttpServer {
    static final HttpServerBind INSTANCE = new HttpServerBind();
    final HttpServerConfig config;
    static final int DEFAULT_PORT = 0;

    HttpServerBind() {
        HashMap<ChannelOption<Boolean>, Boolean> childOptions = new HashMap<ChannelOption<Boolean>, Boolean>(MapUtils.calculateInitialCapacity(2));
        childOptions.put(ChannelOption.AUTO_READ, false);
        childOptions.put(ChannelOption.TCP_NODELAY, true);
        this.config = new HttpServerConfig(Collections.singletonMap(ChannelOption.SO_REUSEADDR, true), childOptions, () -> new InetSocketAddress(0));
    }

    HttpServerBind(HttpServerConfig config) {
        this.config = config;
    }

    @Override
    public Mono<? extends DisposableServer> bind() {
        if (this.config.sslProvider != null) {
            if ((this.config._protocols & 1) == 1) {
                return Mono.error(new IllegalArgumentException("Configured H2 Clear-Text protocol with TLS. Use the non Clear-Text H2 protocol via HttpServer#protocol or disable TLS via HttpServer#noSSL())"));
            }
        } else {
            if ((this.config._protocols & 2) == 2) {
                return Mono.error(new IllegalArgumentException("Configured H2 protocol without TLS. Use a Clear-Text H2 protocol via HttpServer#protocol or configure TLS via HttpServer#secure"));
            }
            if ((this.config._protocols & 8) == 8) {
                return Mono.error(new IllegalArgumentException("Configured HTTP/3 protocol without TLS. Configure TLS via HttpServer#secure"));
            }
        }
        return super.bind();
    }

    @Override
    public HttpServerConfig configuration() {
        return this.config;
    }

    public String toString() {
        return "HttpServer{protocols=" + Arrays.asList(this.configuration().protocols) + ", secure=" + this.configuration().isSecure() + '}';
    }

    @Override
    protected HttpServer duplicate() {
        return new HttpServerBind(new HttpServerConfig(this.config));
    }

    static HttpServer applyTcpServerConfig(TcpServerConfig config) {
        Transport httpServer = (HttpServer)((HttpServer)((HttpServer)((HttpServer)HttpServerBind.create().childObserve(config.childObserver())).doOnChannelInit(config.doOnChannelInit())).observe(config.connectionObserver())).runOn(config.loopResources(), config.isPreferNative());
        for (Map.Entry<AttributeKey<?>, ?> entry : config.attributes().entrySet()) {
            httpServer = (HttpServer)httpServer.attr(entry.getKey(), entry.getValue());
        }
        if (config.bindAddress() != null) {
            httpServer = ((HttpServer)httpServer).bindAddress((Supplier)config.bindAddress());
        }
        if (config.channelGroup() != null) {
            httpServer = ((HttpServer)httpServer).channelGroup(config.channelGroup());
        }
        for (Map.Entry<AttributeKey<?>, ?> entry : config.childAttributes().entrySet()) {
            httpServer = (HttpServer)((ServerTransport)httpServer).childAttr(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<AbstractConstant, ?> entry : config.childOptions().entrySet()) {
            httpServer = (HttpServer)((ServerTransport)httpServer).childOption((ChannelOption)entry.getKey(), entry.getValue());
        }
        if (config.doOnBound() != null) {
            httpServer = (HttpServer)((ServerTransport)httpServer).doOnBound(config.doOnBound());
        }
        if (config.doOnConnection() != null) {
            httpServer = (HttpServer)((ServerTransport)httpServer).doOnConnection(config.doOnConnection());
        }
        if (config.doOnUnbound() != null) {
            httpServer = (HttpServer)((ServerTransport)httpServer).doOnUnbound(config.doOnUnbound());
        }
        if (config.loggingHandler() != null) {
            ((HttpServerConfig)httpServer.configuration()).loggingHandler(config.loggingHandler());
        }
        if (config.metricsRecorder() != null) {
            httpServer = ((HttpServer)httpServer).metrics(true, (Supplier)config.metricsRecorder());
        }
        for (Map.Entry<AbstractConstant, ?> entry : config.options().entrySet()) {
            httpServer = (HttpServer)httpServer.option((ChannelOption)entry.getKey(), entry.getValue());
        }
        if (config.sslProvider() != null) {
            ((HttpServer)httpServer).secure(config.sslProvider());
        }
        return httpServer;
    }
}

