/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression;

import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.CompressionOptions;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.GzipOptions;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.StandardCompressionOptions;
import com.dataiku.dss.shadelibazure.io.netty.util.internal.ObjectUtil;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.HttpCompressionOption;

public final class GzipOption
implements HttpCompressionOption {
    private final int compressionLevel;
    private final int memoryLevel;
    private final int windowBits;

    private GzipOption(Build build) {
        this.compressionLevel = build.compressionLevel;
        this.memoryLevel = build.memoryLevel;
        this.windowBits = build.windowBits;
    }

    static GzipOption provideDefault() {
        return GzipOption.builder().build();
    }

    CompressionOptions adapt() {
        return StandardCompressionOptions.gzip(this.compressionLevel, this.windowBits, this.memoryLevel);
    }

    public static Builder builder() {
        return new Build();
    }

    private static final class Build
    implements Builder {
        static final GzipOptions DEFAULT = StandardCompressionOptions.gzip();
        private int compressionLevel = DEFAULT.compressionLevel();
        private int memoryLevel = DEFAULT.memLevel();
        private int windowBits = DEFAULT.windowBits();

        private Build() {
        }

        @Override
        public GzipOption build() {
            return new GzipOption(this);
        }

        @Override
        public Builder compressionLevel(int compressionLevel) {
            ObjectUtil.checkInRange(compressionLevel, 0, 9, "compressionLevel");
            this.compressionLevel = compressionLevel;
            return this;
        }

        @Override
        public Builder memoryLevel(int memoryLevel) {
            ObjectUtil.checkInRange(memoryLevel, 1, 9, "memoryLevel");
            this.memoryLevel = memoryLevel;
            return this;
        }

        @Override
        public Builder windowBits(int windowBits) {
            ObjectUtil.checkInRange(windowBits, 9, 15, "windowBits");
            this.windowBits = windowBits;
            return this;
        }
    }

    public static interface Builder {
        public GzipOption build();

        public Builder compressionLevel(int var1);

        public Builder memoryLevel(int var1);

        public Builder windowBits(int var1);
    }
}

