/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging;

import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

final class AccessLogArgProviderH1
extends AbstractAccessLogArgProvider<AccessLogArgProviderH1> {
    HttpServerRequest request;
    HttpResponse response;

    AccessLogArgProviderH1(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH1(AccessLogArgProviderH1 copy) {
        super(copy);
        this.request = copy.request;
        this.response = copy.response;
    }

    AccessLogArgProviderH1 request(HttpServerRequest request) {
        this.request = Objects.requireNonNull(request, "request");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH1 response(HttpResponse response) {
        this.response = Objects.requireNonNull(response, "response");
        return this.get();
    }

    @Override
    @Nullable
    public CharSequence status() {
        return this.response == null ? null : this.response.status().codeAsText();
    }

    @Override
    @Nullable
    public CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.request == null ? null : this.request.requestHeaders().get(name);
    }

    @Override
    @Nullable
    public CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.response == null ? null : this.response.headers().get(name);
    }

    @Override
    @Nullable
    public Iterator<Map.Entry<CharSequence, CharSequence>> requestHeaderIterator() {
        return this.request == null ? null : this.request.requestHeaders().iteratorCharSequence();
    }

    @Override
    @Nullable
    public Iterator<Map.Entry<CharSequence, CharSequence>> responseHeaderIterator() {
        return this.response == null ? null : this.response.headers().iteratorCharSequence();
    }

    @Override
    void onRequest() {
        if (this.request != null) {
            this.accessDateTime = this.request.timestamp();
            this.zonedDateTime = this.accessDateTime.format(DATE_TIME_FORMATTER);
            this.startTime = this.accessDateTime.toInstant().toEpochMilli();
            this.method = this.request.method().name();
            this.uri = this.request.uri();
            this.protocol = this.request.protocol();
            this.cookies = this.request.cookies();
            this.connectionInfo = this.request;
        }
    }

    @Override
    void clear() {
        super.clear();
        this.request = null;
        this.response = null;
    }

    AccessLogArgProviderH1 contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.get();
    }

    @Override
    public AccessLogArgProviderH1 get() {
        return this;
    }
}

