/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufHolder;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpMessage;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpUtil;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProviderH1;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.BaseAccessLogHandler;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.function.Function;

final class AccessLogHandlerH1
extends BaseAccessLogHandler {
    static final boolean LAST_FLUSH_WHEN_NO_READ = Boolean.parseBoolean(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.http.server.lastFlushWhenNoRead", "false"));
    AccessLogArgProviderH1 accessLogArgProvider;

    AccessLogHandlerH1(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        super(accessLog);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            if (status.code() == HttpResponseStatus.CONTINUE.code()) {
                ctx.write(msg, promise);
                return;
            }
            if (this.accessLogArgProvider == null) {
                this.accessLogArgProvider = new AccessLogArgProviderH1(ctx.channel().remoteAddress());
            } else {
                this.accessLogArgProvider.clear();
            }
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            if (ops instanceof HttpServerRequest) {
                this.accessLogArgProvider.request((HttpServerRequest)((Object)ops));
            }
            boolean chunked = HttpUtil.isTransferEncodingChunked(response);
            this.accessLogArgProvider.response(response).chunked(chunked);
            if (!chunked) {
                this.accessLogArgProvider.contentLength(HttpUtil.getContentLength((HttpMessage)response, -1));
            }
        }
        if (msg instanceof LastHttpContent) {
            this.accessLogArgProvider.increaseContentLength(((LastHttpContent)msg).content().readableBytes());
            AccessLogArgProviderH1 copy = LAST_FLUSH_WHEN_NO_READ ? new AccessLogArgProviderH1(this.accessLogArgProvider) : null;
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    AccessLog log;
                    AccessLog accessLog = log = copy != null ? (AccessLog)this.accessLog.apply(copy) : (AccessLog)this.accessLog.apply(this.accessLogArgProvider);
                    if (log != null) {
                        log.log();
                    }
                }
            }));
            return;
        }
        if (msg instanceof ByteBuf) {
            this.accessLogArgProvider.increaseContentLength(((ByteBuf)msg).readableBytes());
        }
        if (msg instanceof ByteBufHolder) {
            this.accessLogArgProvider.increaseContentLength(((ByteBufHolder)msg).content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

