/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2DataFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2HeadersFrame;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerInfos;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProviderH2;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.BaseAccessLogHandler;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.function.Function;

final class AccessLogHandlerH2
extends BaseAccessLogHandler {
    AccessLogArgProviderH2 accessLogArgProvider;

    AccessLogHandlerH2(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        super(accessLog);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame requestHeaders = (Http2HeadersFrame)msg;
            if (this.accessLogArgProvider == null) {
                this.accessLogArgProvider = new AccessLogArgProviderH2(ctx.channel().remoteAddress());
            }
            this.accessLogArgProvider.requestHeaders(requestHeaders);
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        boolean lastContent = false;
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame responseHeaders = (Http2HeadersFrame)msg;
            if (HttpResponseStatus.CONTINUE.codeAsText().contentEquals(responseHeaders.headers().status())) {
                ctx.write(msg, promise);
                return;
            }
            lastContent = responseHeaders.isEndStream();
            this.accessLogArgProvider.responseHeaders(responseHeaders).chunked(true);
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            if (ops instanceof HttpServerInfos) {
                AccessLogHandlerH2.applyServerInfos(this.accessLogArgProvider, (HttpServerInfos)((Object)ops));
            }
        }
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame data = (Http2DataFrame)msg;
            lastContent = data.isEndStream();
            this.accessLogArgProvider.increaseContentLength(data.content().readableBytes());
        }
        if (lastContent) {
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    AccessLog log = (AccessLog)this.accessLog.apply(this.accessLogArgProvider);
                    if (log != null) {
                        log.log();
                    }
                    this.accessLogArgProvider.clear();
                }
            }));
            return;
        }
        ctx.write(msg, promise);
    }
}

