/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelDuplexHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerInfos;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;

class BaseAccessLogHandler
extends ChannelDuplexHandler {
    static final String DEFAULT_LOG_FORMAT = "{} - {} [{}] \"{} {} {}\" {} {} {}";
    static final Function<AccessLogArgProvider, AccessLog> DEFAULT_ACCESS_LOG = args2 -> AccessLog.create(DEFAULT_LOG_FORMAT, BaseAccessLogHandler.applyAddress(args2.remoteAddress()), args2.user(), args2.zonedDateTime(), args2.method(), args2.uri(), args2.protocol(), args2.status(), args2.contentLength() > -1L ? Long.valueOf(args2.contentLength()) : "-", args2.duration());
    final Function<AccessLogArgProvider, AccessLog> accessLog;

    BaseAccessLogHandler(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        this.accessLog = accessLog == null ? DEFAULT_ACCESS_LOG : accessLog;
    }

    static String applyAddress(@Nullable SocketAddress socketAddress) {
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : "-";
    }

    static <T extends AbstractAccessLogArgProvider<T>> void applyServerInfos(AbstractAccessLogArgProvider<T> accessLogArgs, HttpServerInfos serverInfos) {
        accessLogArgs.cookies(serverInfos.cookies());
        accessLogArgs.connectionInformation(serverInfos);
    }
}

