/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerInfos;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.AbstractErrorLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.ZonedDateTime;

final class DefaultErrorLogArgProvider
extends AbstractErrorLogArgProvider<DefaultErrorLogArgProvider> {
    private Throwable cause;
    private ZonedDateTime errorDateTime;
    private HttpServerInfos httpServerInfos;

    DefaultErrorLogArgProvider(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public ZonedDateTime errorDateTime() {
        return this.errorDateTime;
    }

    @Override
    public DefaultErrorLogArgProvider get() {
        return this;
    }

    @Override
    @Nullable
    public HttpServerInfos httpServerInfos() {
        return this.httpServerInfos;
    }

    void clear() {
        this.cause = null;
        this.errorDateTime = null;
        this.httpServerInfos = null;
    }

    void applyConnectionInfo(Channel channel) {
        ChannelOperations<?, ?> ops = ChannelOperations.get(channel);
        if (ops instanceof HttpServerInfos) {
            this.httpServerInfos = (HttpServerInfos)((Object)ops);
        }
    }

    void applyThrowable(Throwable cause) {
        this.cause = cause;
        this.errorDateTime = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
    }
}

