/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.websocket;

import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.function.Supplier;

public interface WebsocketSpec {
    @Nullable
    public String protocols();

    public int maxFramePayloadLength();

    public boolean handlePing();

    public boolean compress();

    public static class Builder<SPEC extends Builder<SPEC>>
    implements Supplier<SPEC> {
        String protocols;
        int maxFramePayloadLength = 65536;
        boolean handlePing;
        boolean compress;

        protected Builder() {
        }

        public final SPEC protocols(String protocols) {
            this.protocols = Objects.requireNonNull(protocols, "protocols");
            return (SPEC)this.get();
        }

        public final SPEC maxFramePayloadLength(int maxFramePayloadLength) {
            if (maxFramePayloadLength <= 0) {
                throw new IllegalArgumentException("Max frame payload length value must be strictly positive");
            }
            this.maxFramePayloadLength = maxFramePayloadLength;
            return (SPEC)this.get();
        }

        public final SPEC handlePing(boolean handlePing) {
            this.handlePing = handlePing;
            return (SPEC)this.get();
        }

        public final SPEC compress(boolean compress) {
            this.compress = compress;
            return (SPEC)this.get();
        }

        @Override
        public SPEC get() {
            return (SPEC)this;
        }
    }
}

