/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool;

import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.Pool;
import java.time.Duration;

public interface InstrumentedPool<POOLABLE>
extends Pool<POOLABLE> {
    public PoolMetrics metrics();

    public static interface PoolMetrics {
        public int acquiredSize();

        public int allocatedSize();

        public int idleSize();

        public int pendingAcquireSize();

        default public long secondsSinceLastInteraction() {
            return -1L;
        }

        default public boolean isInactiveForMoreThan(Duration duration) {
            return this.acquiredSize() == 0 && this.idleSize() == 0 && this.pendingAcquireSize() == 0 && this.allocatedSize() == 0 && !Duration.ofSeconds(this.secondsSinceLastInteraction()).minus(duration).isNegative();
        }

        public int getMaxAllocatedSize();

        public int getMaxPendingAcquireSize();
    }
}

