/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Scheduler;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Schedulers;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.AllocationStrategies;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.AllocationStrategy;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.DefaultPoolConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.NoOpPoolMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.Pool;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.SimpleDequePool;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class PoolBuilder<T, CONF extends PoolConfig<T>> {
    final Mono<T> allocator;
    final Function<PoolConfig<T>, CONF> configModifier;
    int maxPending = -1;
    AllocationStrategy allocationStrategy = null;
    Function<T, ? extends Publisher<Void>> releaseHandler = PoolBuilder.noopHandler();
    Function<T, ? extends Publisher<Void>> destroyHandler = PoolBuilder.noopHandler();
    BiPredicate<T, PooledRefMetadata> evictionPredicate = PoolBuilder.neverPredicate();
    Duration evictionBackgroundInterval = Duration.ZERO;
    Scheduler evictionBackgroundScheduler = Schedulers.immediate();
    Scheduler acquisitionScheduler = Schedulers.immediate();
    Clock clock = Clock.systemUTC();
    PoolMetricsRecorder metricsRecorder = NoOpPoolMetricsRecorder.INSTANCE;
    boolean idleLruOrder = true;
    BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer = DEFAULT_PENDING_ACQUIRE_TIMER;
    static final Function<?, Mono<Void>> NOOP_HANDLER = it -> Mono.empty();
    static final BiPredicate<?, ?> NEVER_PREDICATE = (ignored1, ignored2) -> false;
    static final BiFunction<Runnable, Duration, Disposable> DEFAULT_PENDING_ACQUIRE_TIMER = (r, d) -> Schedulers.parallel().schedule((Runnable)r, d.toNanos(), TimeUnit.NANOSECONDS);
    static final int DEFAULT_WARMUP_PARALLELISM = 1;

    public static <T> PoolBuilder<T, PoolConfig<T>> from(Publisher<? extends T> allocator) {
        Mono<? extends T> source2 = Mono.from(allocator);
        return new PoolBuilder(source2, Function.identity());
    }

    PoolBuilder(Mono<T> allocator, Function<PoolConfig<T>, CONF> configModifier) {
        this.allocator = allocator;
        this.configModifier = configModifier;
    }

    PoolBuilder(PoolBuilder<T, ?> source2, Function<PoolConfig<T>, CONF> configModifier) {
        this.configModifier = configModifier;
        this.allocator = source2.allocator;
        this.maxPending = source2.maxPending;
        this.allocationStrategy = source2.allocationStrategy;
        this.releaseHandler = source2.releaseHandler;
        this.destroyHandler = source2.destroyHandler;
        this.evictionPredicate = source2.evictionPredicate;
        this.evictionBackgroundInterval = source2.evictionBackgroundInterval;
        this.evictionBackgroundScheduler = source2.evictionBackgroundScheduler;
        this.acquisitionScheduler = source2.acquisitionScheduler;
        this.metricsRecorder = source2.metricsRecorder;
        this.clock = source2.clock;
        this.idleLruOrder = source2.idleLruOrder;
        this.pendingAcquireTimer = source2.pendingAcquireTimer;
    }

    public PoolBuilder<T, CONF> acquisitionScheduler(Scheduler acquisitionScheduler) {
        this.acquisitionScheduler = Objects.requireNonNull(acquisitionScheduler, "acquisitionScheduler");
        return this;
    }

    public PoolBuilder<T, CONF> pendingAcquireTimer(BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer) {
        this.pendingAcquireTimer = Objects.requireNonNull(pendingAcquireTimer, "pendingAcquireTimer");
        return this;
    }

    public PoolBuilder<T, CONF> allocationStrategy(AllocationStrategy allocationStrategy) {
        this.allocationStrategy = Objects.requireNonNull(allocationStrategy, "allocationStrategy");
        return this;
    }

    public PoolBuilder<T, CONF> destroyHandler(Function<T, ? extends Publisher<Void>> destroyHandler) {
        this.destroyHandler = Objects.requireNonNull(destroyHandler, "destroyHandler");
        return this;
    }

    public PoolBuilder<T, CONF> evictionIdle(Duration maxIdleTime) {
        return this.evictionPredicate(PoolBuilder.idlePredicate(maxIdleTime));
    }

    public PoolBuilder<T, CONF> evictionPredicate(BiPredicate<T, PooledRefMetadata> evictionPredicate) {
        this.evictionPredicate = Objects.requireNonNull(evictionPredicate, "evictionPredicate");
        return this;
    }

    public PoolBuilder<T, CONF> evictInBackgroundDisabled() {
        return this.evictInBackground(Duration.ZERO);
    }

    public PoolBuilder<T, CONF> evictInBackground(Duration evictionInterval) {
        if (evictionInterval == Duration.ZERO) {
            this.evictionBackgroundInterval = Duration.ZERO;
            this.evictionBackgroundScheduler = Schedulers.immediate();
            return this;
        }
        return this.evictInBackground(evictionInterval, Schedulers.parallel());
    }

    public PoolBuilder<T, CONF> evictInBackground(Duration evictionInterval, Scheduler reaperTaskScheduler) {
        this.evictionBackgroundInterval = evictionInterval;
        this.evictionBackgroundScheduler = reaperTaskScheduler;
        return this;
    }

    public PoolBuilder<T, CONF> maxPendingAcquire(int maxPending) {
        this.maxPending = maxPending;
        return this;
    }

    public PoolBuilder<T, CONF> maxPendingAcquireUnbounded() {
        this.maxPending = -1;
        return this;
    }

    public PoolBuilder<T, CONF> clock(Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
        return this;
    }

    public PoolBuilder<T, CONF> metricsRecorder(PoolMetricsRecorder recorder) {
        this.metricsRecorder = Objects.requireNonNull(recorder, "recorder");
        return this;
    }

    public PoolBuilder<T, CONF> releaseHandler(Function<T, ? extends Publisher<Void>> releaseHandler) {
        this.releaseHandler = Objects.requireNonNull(releaseHandler, "releaseHandler");
        return this;
    }

    public PoolBuilder<T, CONF> sizeBetween(int min2, int max) {
        return this.sizeBetween(min2, max, 1);
    }

    public PoolBuilder<T, CONF> sizeBetween(int min2, int max, int warmupParallelism) {
        return this.allocationStrategy(new AllocationStrategies.SizeBasedAllocationStrategy(min2, max, warmupParallelism));
    }

    public PoolBuilder<T, CONF> sizeUnbounded() {
        return this.allocationStrategy(new AllocationStrategies.UnboundedAllocationStrategy());
    }

    public PoolBuilder<T, CONF> idleResourceReuseLruOrder() {
        return this.idleResourceReuseOrder(true);
    }

    public PoolBuilder<T, CONF> idleResourceReuseMruOrder() {
        return this.idleResourceReuseOrder(false);
    }

    public PoolBuilder<T, CONF> idleResourceReuseOrder(boolean isLru) {
        this.idleLruOrder = isLru;
        return this;
    }

    public <CONF2 extends PoolConfig<T>> PoolBuilder<T, CONF2> extraConfiguration(Function<? super CONF, CONF2> configModifier) {
        return new PoolBuilder<T, CONF2>(this, this.configModifier.andThen(configModifier));
    }

    public InstrumentedPool<T> buildPool() {
        return new SimpleDequePool(this.buildConfig());
    }

    public <P extends InstrumentedPool<T>> P buildPoolAndDecorateWith(Function<? super InstrumentedPool<T>, P> decorator) {
        return (P)((InstrumentedPool)decorator.apply(this.buildPool()));
    }

    public <POOL extends Pool<T>> POOL build(Function<? super CONF, POOL> poolFactory) {
        CONF config = this.buildConfig();
        return (POOL)((Pool)poolFactory.apply(config));
    }

    CONF buildConfig() {
        DefaultPoolConfig<T> baseConfig = new DefaultPoolConfig<T>(this.allocator, this.allocationStrategy == null ? new AllocationStrategies.UnboundedAllocationStrategy() : this.allocationStrategy, this.maxPending, this.pendingAcquireTimer, this.releaseHandler, this.destroyHandler, this.evictionPredicate, this.evictionBackgroundInterval, this.evictionBackgroundScheduler, this.acquisitionScheduler, this.metricsRecorder, this.clock, this.idleLruOrder);
        return (CONF)((PoolConfig)this.configModifier.apply(baseConfig));
    }

    static <T> Function<T, Mono<Void>> noopHandler() {
        return NOOP_HANDLER;
    }

    static <T> BiPredicate<T, PooledRefMetadata> neverPredicate() {
        return NEVER_PREDICATE;
    }

    static <T> BiPredicate<T, PooledRefMetadata> idlePredicate(Duration maxIdleTime) {
        return (poolable, meta) -> meta.idleTime() >= maxIdleTime.toMillis();
    }
}

