/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Gauge;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Meter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Tags;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProviderMeters;
import java.net.SocketAddress;

final class MicrometerPooledConnectionProviderMeterRegistrar {
    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    static void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of((String[])new String[]{ConnectionProviderMeters.ConnectionProviderMetersTags.ID.asString(), id, ConnectionProviderMeters.ConnectionProviderMetersTags.REMOTE_ADDRESS.asString(), addressAsString, ConnectionProviderMeters.ConnectionProviderMetersTags.NAME.asString(), poolName});
        Gauge.builder((String)ConnectionProviderMeters.TOTAL_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::allocatedSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)ConnectionProviderMeters.ACTIVE_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)ConnectionProviderMeters.IDLE_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)ConnectionProviderMeters.PENDING_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)ConnectionProviderMeters.MAX_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::getMaxAllocatedSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)ConnectionProviderMeters.MAX_PENDING_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::getMaxPendingAcquireSize).tags((Iterable)tags).register(Metrics.REGISTRY);
    }

    static void deRegisterMetrics(String poolName, String id, SocketAddress remoteAddress) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of((String[])new String[]{ConnectionProviderMeters.ConnectionProviderMetersTags.ID.asString(), id, ConnectionProviderMeters.ConnectionProviderMetersTags.REMOTE_ADDRESS.asString(), addressAsString, ConnectionProviderMeters.ConnectionProviderMetersTags.NAME.asString(), poolName});
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.TOTAL_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.ACTIVE_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.IDLE_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.PENDING_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.MAX_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.MAX_PENDING_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
    }
}

