/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.tcp;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.util.NetUtil;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.TcpClient;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.TcpClientConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.AddressUtils;
import java.util.Collections;

final class TcpClientConnect
extends TcpClient {
    final TcpClientConfig config;
    static final int DEFAULT_PORT;

    TcpClientConnect(ConnectionProvider provider) {
        this.config = new TcpClientConfig(provider, Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), DEFAULT_PORT));
    }

    TcpClientConnect(TcpClientConfig config) {
        this.config = config;
    }

    @Override
    public TcpClientConfig configuration() {
        return this.config;
    }

    @Override
    protected TcpClient duplicate() {
        return new TcpClientConnect(new TcpClientConfig(this.config));
    }

    static {
        int port;
        String portStr = null;
        try {
            portStr = System.getenv("PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }
}

