/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.transport;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.buffer.PooledByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.buffer.UnpooledByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFactory;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.group.ChannelGroup;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LoggingHandler;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelPipelineConfigurer;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ByteBufAllocatorMetrics;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.MicrometerEventLoopMeterRegistrar;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class TransportConfig {
    Map<AttributeKey<?>, ?> attrs;
    Supplier<? extends SocketAddress> bindAddress;
    ChannelGroup channelGroup;
    ChannelPipelineConfigurer doOnChannelInit;
    LoggingHandler loggingHandler;
    LoopResources loopResources;
    ChannelMetricsRecorder metricsRecorder;
    ConnectionObserver observer;
    Map<ChannelOption<?>, ?> options;
    boolean preferNative;
    static final Logger log = Loggers.getLogger(TransportConfig.class);

    public final Map<AttributeKey<?>, ?> attributes() {
        if (this.attrs.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attrs);
    }

    @Nullable
    public final Supplier<? extends SocketAddress> bindAddress() {
        return this.bindAddress;
    }

    public int channelHash() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.attrs);
        result = 31 * result + (this.bindAddress != null ? Objects.hashCode(this.bindAddress.get()) : 0);
        result = 31 * result + Objects.hashCode(this.channelGroup);
        result = 31 * result + Objects.hashCode(this.doOnChannelInit);
        result = 31 * result + Objects.hashCode(this.loggingHandler);
        result = 31 * result + Objects.hashCode(this.loopResources);
        result = 31 * result + Objects.hashCode(this.metricsRecorder);
        result = 31 * result + Objects.hashCode(this.observer);
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Boolean.hashCode(this.preferNative);
        return result;
    }

    @Nullable
    public final ChannelGroup channelGroup() {
        return this.channelGroup;
    }

    public ChannelInitializer<Channel> channelInitializer(ConnectionObserver connectionObserver, @Nullable SocketAddress remoteAddress, boolean onServer) {
        Objects.requireNonNull(connectionObserver, "connectionObserver");
        return new TransportChannelInitializer(this, connectionObserver, remoteAddress, onServer);
    }

    public ChannelOperations.OnSetup channelOperationsProvider() {
        return ChannelOperations.OnSetup.empty();
    }

    public final ConnectionObserver connectionObserver() {
        return this.observer;
    }

    public final ChannelPipelineConfigurer doOnChannelInit() {
        return this.doOnChannelInit;
    }

    public final boolean isPreferNative() {
        return this.preferNative;
    }

    @Nullable
    public final LoggingHandler loggingHandler() {
        return this.loggingHandler;
    }

    public final LoopResources loopResources() {
        return this.loopResources != null ? this.loopResources : this.defaultLoopResources();
    }

    @Nullable
    public final Supplier<? extends ChannelMetricsRecorder> metricsRecorder() {
        return this.metricsRecorder != null ? () -> this.metricsRecorder : null;
    }

    public final Map<ChannelOption<?>, ?> options() {
        if (this.options.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.options);
    }

    protected TransportConfig(Map<ChannelOption<?>, ?> options) {
        this.attrs = Collections.emptyMap();
        this.doOnChannelInit = ChannelPipelineConfigurer.emptyConfigurer();
        this.observer = ConnectionObserver.emptyListener();
        this.options = Objects.requireNonNull(options, "options");
        this.preferNative = LoopResources.DEFAULT_NATIVE;
    }

    protected TransportConfig(Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> bindAddress) {
        this.attrs = Collections.emptyMap();
        this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
        this.doOnChannelInit = ChannelPipelineConfigurer.emptyConfigurer();
        this.observer = ConnectionObserver.emptyListener();
        this.options = Objects.requireNonNull(options, "options");
        this.preferNative = LoopResources.DEFAULT_NATIVE;
    }

    protected TransportConfig(TransportConfig parent) {
        this.attrs = parent.attrs;
        this.bindAddress = parent.bindAddress;
        this.channelGroup = parent.channelGroup;
        this.doOnChannelInit = parent.doOnChannelInit;
        this.loggingHandler = parent.loggingHandler;
        this.loopResources = parent.loopResources;
        this.metricsRecorder = parent.metricsRecorder;
        this.observer = parent.observer;
        this.options = parent.options;
        this.preferNative = parent.preferNative;
    }

    protected void bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        this.bindAddress = bindAddressSupplier;
    }

    protected abstract Class<? extends Channel> channelType(boolean var1);

    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        return () -> this.loopResources().onChannel(this.channelType(isDomainSocket), elg);
    }

    protected abstract ConnectionObserver defaultConnectionObserver();

    protected abstract LoggingHandler defaultLoggingHandler();

    protected abstract LoopResources defaultLoopResources();

    protected abstract ChannelMetricsRecorder defaultMetricsRecorder();

    protected abstract ChannelPipelineConfigurer defaultOnChannelInit();

    protected abstract EventLoopGroup eventLoopGroup();

    protected void loggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    protected void metricsRecorder(@Nullable Supplier<? extends ChannelMetricsRecorder> metricsRecorderSupplier) {
        this.metricsRecorder = metricsRecorderSupplier != null ? metricsRecorderSupplier.get() : null;
    }

    @Nullable
    protected ChannelMetricsRecorder metricsRecorderInternal() {
        return this.metricsRecorder;
    }

    protected static <K, V> Map<K, V> updateMap(Map<K, V> parentMap, Object key, @Nullable Object value) {
        if (parentMap.isEmpty()) {
            return value == null ? parentMap : Collections.singletonMap(key, value);
        }
        HashMap<Object, Object> attrs = new HashMap<Object, Object>(MapUtils.calculateInitialCapacity(parentMap.size() + 1));
        attrs.putAll(parentMap);
        if (value == null) {
            attrs.remove(key);
        } else {
            attrs.put(key, value);
        }
        return attrs;
    }

    static final class TransportChannelInitializer
    extends ChannelInitializer<Channel> {
        final TransportConfig config;
        final ConnectionObserver connectionObserver;
        final boolean onServer;
        final SocketAddress remoteAddress;

        TransportChannelInitializer(TransportConfig config, ConnectionObserver connectionObserver, @Nullable SocketAddress remoteAddress, boolean onServer) {
            this.config = config;
            this.connectionObserver = connectionObserver;
            this.onServer = onServer;
            this.remoteAddress = remoteAddress;
        }

        @Override
        protected void initChannel(Channel channel) {
            ChannelPipeline pipeline;
            block9: {
                pipeline = channel.pipeline();
                if (this.config.metricsRecorder != null) {
                    ChannelOperations.addMetricsHandler(channel, this.config.metricsRecorder, this.remoteAddress, this.onServer);
                    if (Metrics.isMicrometerAvailable()) {
                        try {
                            ByteBufAllocator alloc = channel.alloc();
                            if (alloc instanceof PooledByteBufAllocator) {
                                ByteBufAllocatorMetrics.INSTANCE.registerMetrics("pooled", ((PooledByteBufAllocator)alloc).metric(), alloc);
                            } else if (alloc instanceof UnpooledByteBufAllocator) {
                                ByteBufAllocatorMetrics.INSTANCE.registerMetrics("unpooled", ((UnpooledByteBufAllocator)alloc).metric(), alloc);
                            }
                            MicrometerEventLoopMeterRegistrar.INSTANCE.registerMetrics(channel.eventLoop());
                        }
                        catch (RuntimeException e) {
                            if (!log.isWarnEnabled()) break block9;
                            log.warn(ReactorNetty.format(channel, "Exception caught while recording metrics."), e);
                        }
                    }
                }
            }
            if (this.config.loggingHandler != null) {
                pipeline.addFirst("com.dataiku.dss.shadelibazure.reactor.left.loggingHandler", (ChannelHandler)this.config.loggingHandler);
            }
            ChannelOperations.addReactiveBridge(channel, this.config.channelOperationsProvider(), this.connectionObserver);
            this.config.defaultOnChannelInit().then(this.config.doOnChannelInit).onChannelInit(this.connectionObserver, channel, this.remoteAddress);
            pipeline.remove(this);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Initialized pipeline {}"), pipeline.toString());
            }
        }
    }
}

