/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.util.NetUtil;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpClient;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpClientConfig;
import java.net.InetSocketAddress;
import java.util.Collections;

final class UdpClientConnect
extends UdpClient {
    static final UdpClientConnect INSTANCE;
    final UdpClientConfig config;
    static final int DEFAULT_PORT;

    UdpClientConnect() {
        this.config = new UdpClientConfig(ConnectionProvider.newConnection(), Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, DEFAULT_PORT));
    }

    UdpClientConnect(UdpClientConfig config) {
        this.config = config;
    }

    @Override
    public UdpClientConfig configuration() {
        return this.config;
    }

    @Override
    protected UdpClient duplicate() {
        return new UdpClientConnect(new UdpClientConfig(this.config));
    }

    static {
        int port;
        INSTANCE = new UdpClientConnect();
        String portStr = null;
        try {
            portStr = System.getenv("PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }
}

