/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.InternetProtocolFamily;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LogLevel;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.AddressUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.Transport;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpOutbound;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpServerBind;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpServerConfig;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class UdpServer
extends Transport<UdpServer, UdpServerConfig> {
    static final Logger log = Loggers.getLogger(UdpServer.class);

    public static UdpServer create() {
        return UdpServerBind.INSTANCE;
    }

    @Override
    public final <A> UdpServer attr(AttributeKey<A> key, @Nullable A value) {
        return (UdpServer)super.attr(key, value);
    }

    public abstract Mono<? extends Connection> bind();

    @Override
    public final UdpServer bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        return (UdpServer)super.bindAddress(bindAddressSupplier);
    }

    public final Connection bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final Connection bindNow(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        try {
            return Objects.requireNonNull(this.bind().block(timeout2), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("UdpServer couldn't be started within " + timeout2.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final UdpServer doOnBind(Consumer<? super UdpServerConfig> doOnBind) {
        Objects.requireNonNull(doOnBind, "doOnBind");
        UdpServer dup = (UdpServer)this.duplicate();
        Consumer<? super UdpServerConfig> current = ((UdpServerConfig)dup.configuration()).doOnBind;
        ((UdpServerConfig)dup.configuration()).doOnBind = current == null ? doOnBind : current.andThen(doOnBind);
        return dup;
    }

    public final UdpServer doOnBound(Consumer<? super Connection> doOnBound) {
        Objects.requireNonNull(doOnBound, "doOnBound");
        UdpServer dup = (UdpServer)this.duplicate();
        Consumer<? super Connection> current = ((UdpServerConfig)dup.configuration()).doOnBound;
        ((UdpServerConfig)dup.configuration()).doOnBound = current == null ? doOnBound : current.andThen(doOnBound);
        return dup;
    }

    public final UdpServer doOnUnbound(Consumer<? super Connection> doOnUnbound) {
        Objects.requireNonNull(doOnUnbound, "doOnUnbound");
        UdpServer dup = (UdpServer)this.duplicate();
        Consumer<? super Connection> current = ((UdpServerConfig)dup.configuration()).doOnUnbound;
        ((UdpServerConfig)dup.configuration()).doOnUnbound = current == null ? doOnUnbound : current.andThen(doOnUnbound);
        return dup;
    }

    public final UdpServer handle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnBound(new OnBoundHandle(handler));
    }

    public final UdpServer host(String host) {
        return this.bindAddress(() -> AddressUtils.updateHost(((UdpServerConfig)this.configuration()).bindAddress(), host));
    }

    @Override
    public final UdpServer metrics(boolean enable) {
        return (UdpServer)super.metrics(enable);
    }

    @Override
    public final UdpServer metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (UdpServer)super.metrics(enable, recorder);
    }

    @Override
    public final UdpServer observe(ConnectionObserver observer) {
        return (UdpServer)super.observe(observer);
    }

    @Override
    public final <O> UdpServer option(ChannelOption<O> key, @Nullable O value) {
        return (UdpServer)super.option(key, value);
    }

    public final UdpServer port(int port) {
        return this.bindAddress(() -> AddressUtils.updatePort(((UdpServerConfig)this.configuration()).bindAddress(), port));
    }

    @Override
    public final UdpServer runOn(EventLoopGroup eventLoopGroup) {
        return (UdpServer)super.runOn(eventLoopGroup);
    }

    @Override
    public final UdpServer runOn(LoopResources channelResources) {
        return (UdpServer)super.runOn(channelResources);
    }

    @Override
    public final UdpServer runOn(LoopResources loopResources, boolean preferNative) {
        Objects.requireNonNull(loopResources, "loopResources");
        UdpServer dup = (UdpServer)super.runOn(loopResources, preferNative);
        ((UdpServerConfig)dup.configuration()).family = null;
        return dup;
    }

    public final UdpServer runOn(LoopResources loopResources, InternetProtocolFamily family) {
        Objects.requireNonNull(loopResources, "loopResources");
        Objects.requireNonNull(family, "family");
        UdpServer dup = (UdpServer)super.runOn(loopResources, false);
        ((UdpServerConfig)dup.configuration()).family = family;
        return dup;
    }

    public final Mono<Void> warmup() {
        return Mono.fromRunnable(() -> ((UdpServerConfig)this.configuration()).eventLoopGroup());
    }

    @Override
    public final UdpServer wiretap(boolean enable) {
        return (UdpServer)super.wiretap(enable);
    }

    @Override
    public final UdpServer wiretap(String category) {
        return (UdpServer)super.wiretap(category);
    }

    @Override
    public final UdpServer wiretap(String category, LogLevel level) {
        return (UdpServer)super.wiretap(category, level);
    }

    static final class OnBoundHandle
    implements Consumer<Connection> {
        final BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler;

        OnBoundHandle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Connection c) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), this.handler);
            }
            Mono.fromDirect(this.handler.apply((UdpInbound)((Object)c), (UdpOutbound)((Object)c))).subscribe(c.disposeSubscriber());
        }
    }
}

