/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.store;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.concurrent.atomic.AtomicInteger;

final class RefCountedSharedArena
implements Arena {
    static final int DEFAULT_MAX_PERMITS = 1024;
    private static final int CLOSED = 0;
    private static final int REMAINING_UNIT = 65536;
    private static final int ACQUIRE_DECREMENT = 65535;
    private final String segmentName;
    private final Runnable onClose;
    private final Arena arena;
    private final AtomicInteger state;

    RefCountedSharedArena(String segmentName, Runnable onClose) {
        this(segmentName, onClose, 1024);
    }

    RefCountedSharedArena(String segmentName, Runnable onClose, int maxPermits) {
        if (!RefCountedSharedArena.validMaxPermits(maxPermits)) {
            throw new IllegalArgumentException("invalid max permits: " + maxPermits);
        }
        this.segmentName = segmentName;
        this.onClose = onClose;
        this.arena = Arena.ofShared();
        this.state = new AtomicInteger(maxPermits << 16);
    }

    static boolean validMaxPermits(int v) {
        return v > 0 && v <= Short.MAX_VALUE;
    }

    String getSegmentName() {
        return this.segmentName;
    }

    boolean acquire() {
        int value;
        do {
            if ((value = this.state.get()) >= 65536) continue;
            return false;
        } while (!this.state.compareAndSet(value, value - 65535));
        return true;
    }

    void release() {
        int count;
        int newValue;
        int value;
        do {
            if ((count = (value = this.state.get()) & 0xFFFF) != 0) continue;
            throw new IllegalStateException(value == 0 ? "closed" : "nothing to release");
        } while (!this.state.compareAndSet(value, newValue = count == 1 ? 0 : value - 1));
        if (newValue == 0) {
            this.onClose.run();
            this.arena.close();
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public MemorySegment allocate(long byteSize, long byteAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MemorySegment.Scope scope() {
        return this.arena.scope();
    }

    public String toString() {
        return "RefCountedArena[segmentName=" + this.segmentName + ", value=" + this.state.get() + ", arena=" + this.arena + "]";
    }
}

