/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk;

import com.dataiku.dss.shadelib.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWT;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTParser;
import com.dataiku.dss.shadelib.com.nimbusds.langtag.LangTag;
import com.dataiku.dss.shadelib.com.nimbusds.langtag.LangTagException;
import com.dataiku.dss.shadelib.com.nimbusds.langtag.LangTagUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AbstractRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.SerializeException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.ClientID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.State;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.URIUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.URLUtils;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class LogoutRequest
extends AbstractRequest {
    private final JWT idTokenHint;
    private final String logoutHint;
    private final ClientID clientID;
    private final URI postLogoutRedirectURI;
    private final State state;
    private final List<LangTag> uiLocales;

    public LogoutRequest(URI endpoint, JWT idTokenHint, String logoutHint, ClientID clientID, URI postLogoutRedirectURI, State state, List<LangTag> uiLocales) {
        super(endpoint);
        this.idTokenHint = idTokenHint;
        this.logoutHint = logoutHint;
        this.clientID = clientID;
        this.postLogoutRedirectURI = postLogoutRedirectURI;
        if (postLogoutRedirectURI == null && state != null) {
            throw new IllegalArgumentException("The state parameter requires a post-logout redirection URI");
        }
        this.state = state;
        this.uiLocales = uiLocales;
    }

    public LogoutRequest(URI endpoint, JWT idTokenHint, URI postLogoutRedirectURI, State state) {
        this(endpoint, idTokenHint, null, null, postLogoutRedirectURI, state, null);
    }

    public LogoutRequest(URI endpoint, JWT idTokenHint) {
        this(endpoint, idTokenHint, null, null);
    }

    public LogoutRequest(URI endpoint) {
        this(endpoint, null, null, null);
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLogoutHint() {
        return this.logoutHint;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URI getPostLogoutRedirectionURI() {
        return this.postLogoutRedirectURI;
    }

    public State getState() {
        return this.state;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        if (this.getIDTokenHint() != null) {
            try {
                params.put("id_token_hint", Collections.singletonList(this.getIDTokenHint().serialize()));
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token: " + e.getMessage(), e);
            }
        }
        if (this.getLogoutHint() != null) {
            params.put("logout_hint", Collections.singletonList(this.getLogoutHint()));
        }
        if (this.getClientID() != null) {
            params.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (this.getPostLogoutRedirectionURI() != null) {
            params.put("post_logout_redirect_uri", Collections.singletonList(this.getPostLogoutRedirectionURI().toString()));
        }
        if (this.getState() != null) {
            params.put("state", Collections.singletonList(this.getState().getValue()));
        }
        if (this.getUILocales() != null) {
            params.put("ui_locales", Collections.singletonList(LangTagUtils.concat(this.getUILocales())));
        }
        return params;
    }

    public String toQueryString() {
        return URLUtils.serializeParameters(this.toParameters());
    }

    public URI toURI() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The end-session endpoint URI is not specified");
        }
        HashMap<String, List<String>> mergedQueryParams = new HashMap<String, List<String>>(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        mergedQueryParams.putAll(this.toParameters());
        String query = URLUtils.serializeParameters(mergedQueryParams);
        if (StringUtils.isNotBlank(query)) {
            query = '?' + query;
        }
        try {
            return new URI(URIUtils.getBaseURI(this.getEndpointURI()) + query);
        }
        catch (URISyntaxException e) {
            throw new SerializeException(e.getMessage(), e);
        }
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL baseURL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        LinkedHashMap<String, List<String>> mergedQueryParams = new LinkedHashMap<String, List<String>>(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        mergedQueryParams.putAll(this.toParameters());
        try {
            baseURL = URLUtils.getBaseURL(this.getEndpointURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, baseURL);
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        httpRequest.setBody(URLUtils.serializeParameters(mergedQueryParams));
        return httpRequest;
    }

    public static LogoutRequest parse(Map<String, List<String>> params) throws ParseException {
        return LogoutRequest.parse(null, params);
    }

    public static LogoutRequest parse(URI uri, Map<String, List<String>> params) throws ParseException {
        List<LangTag> uiLocales;
        String v = MultivaluedMapUtils.getFirstValue(params, "id_token_hint");
        JWT idTokenHint = null;
        if (StringUtils.isNotBlank(v)) {
            try {
                idTokenHint = JWTParser.parse(v);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid id_token_hint: " + e.getMessage(), e);
            }
        }
        String logoutHint = MultivaluedMapUtils.getFirstValue(params, "logout_hint");
        ClientID clientID = null;
        v = MultivaluedMapUtils.getFirstValue(params, "client_id");
        if (StringUtils.isNotBlank(v)) {
            clientID = new ClientID(v);
        }
        v = MultivaluedMapUtils.getFirstValue(params, "post_logout_redirect_uri");
        URI postLogoutRedirectURI = null;
        if (StringUtils.isNotBlank(v)) {
            try {
                postLogoutRedirectURI = new URI(v);
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid post_logout_redirect_uri parameter: " + e.getMessage(), e);
            }
        }
        State state = null;
        v = MultivaluedMapUtils.getFirstValue(params, "state");
        if (postLogoutRedirectURI != null && StringUtils.isNotBlank(v)) {
            state = new State(v);
        }
        try {
            uiLocales = LangTagUtils.parseLangTagList(MultivaluedMapUtils.getFirstValue(params, "ui_locales"));
        }
        catch (LangTagException e) {
            throw new ParseException("Invalid ui_locales parameter: " + e.getMessage(), e);
        }
        return new LogoutRequest(uri, idTokenHint, logoutHint, clientID, postLogoutRedirectURI, state, uiLocales);
    }

    public static LogoutRequest parse(String query) throws ParseException {
        return LogoutRequest.parse(null, URLUtils.parseParameters(query));
    }

    public static LogoutRequest parse(URI uri, String query) throws ParseException {
        return LogoutRequest.parse(uri, URLUtils.parseParameters(query));
    }

    public static LogoutRequest parse(URI uri) throws ParseException {
        return LogoutRequest.parse(URIUtils.getBaseURI(uri), URLUtils.parseParameters(uri.getRawQuery()));
    }

    public static LogoutRequest parse(HTTPRequest httpRequest) throws ParseException {
        if (HTTPRequest.Method.POST.equals((Object)httpRequest.getMethod())) {
            httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
            return LogoutRequest.parse(httpRequest.getURI(), httpRequest.getBodyAsFormParameters());
        }
        if (HTTPRequest.Method.GET.equals((Object)httpRequest.getMethod())) {
            return LogoutRequest.parse(httpRequest.getURI());
        }
        throw new ParseException("The HTTP request method must be POST or GET");
    }
}

