/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.parser.processors;

import com.dataiku.dss.shadelib.io.swagger.models.Model;
import com.dataiku.dss.shadelib.io.swagger.models.RefModel;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.parser.ResolverCache;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.ModelProcessor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefinitionsProcessor {
    private final ResolverCache cache;
    private final Swagger swagger;
    private final ModelProcessor modelProcessor;

    public DefinitionsProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
        this.modelProcessor = new ModelProcessor(cache, swagger);
    }

    public void processDefinitions() {
        Map<String, Model> definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            return;
        }
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        while (definitions.keySet().size() > keySet.size()) {
            this.processDefinitions(keySet, definitions);
        }
    }

    public void processDefinitions(Set<String> modelKeys, Map<String, Model> definitions) {
        modelKeys.addAll(definitions.keySet());
        for (String modelName : modelKeys) {
            String renamedRef;
            Model model = definitions.get(modelName);
            String originalRef = model instanceof RefModel ? ((RefModel)model).get$ref() : null;
            this.modelProcessor.processModel(model);
            if (!(model instanceof RefModel) || (renamedRef = this.cache.getRenamedRef(originalRef)) == null) continue;
            Model resolvedModel = definitions.get(renamedRef);
            if (!this.cache.hasReferencedKey(renamedRef)) {
                definitions.remove(renamedRef);
            }
            definitions.put(modelName, resolvedModel);
        }
    }
}

