/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.util;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.node.TextNode;
import com.dataiku.dss.shadelib.io.swagger.models.ArrayModel;
import com.dataiku.dss.shadelib.io.swagger.models.BooleanValueModel;
import com.dataiku.dss.shadelib.io.swagger.models.ComposedModel;
import com.dataiku.dss.shadelib.io.swagger.models.Model;
import com.dataiku.dss.shadelib.io.swagger.models.ModelImpl;
import com.dataiku.dss.shadelib.io.swagger.models.RefModel;
import com.dataiku.dss.shadelib.io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelDeserializer
extends JsonDeserializer<Model> {
    @Override
    public Model deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (node.isBoolean()) {
            return new BooleanValueModel(node.asBoolean());
        }
        JsonNode sub = node.get("$ref");
        JsonNode allOf = node.get("allOf");
        if (sub != null) {
            return Json.mapper().convertValue((Object)sub, RefModel.class);
        }
        if (allOf != null) {
            ComposedModel model = null;
            model = Json.mapper().convertValue((Object)node, ComposedModel.class);
            List<Model> allComponents = model.getAllOf();
            if (allComponents.size() >= 1) {
                model.setParent(allComponents.get(0));
                if (allComponents.size() >= 2) {
                    model.setChild(allComponents.get(allComponents.size() - 1));
                    ArrayList<RefModel> interfaces = new ArrayList<RefModel>();
                    int size = allComponents.size();
                    for (Model m4 : allComponents.subList(1, size - 1)) {
                        if (!(m4 instanceof RefModel)) continue;
                        RefModel ref = (RefModel)m4;
                        interfaces.add(ref);
                    }
                    model.setInterfaces(interfaces);
                } else {
                    model.setChild(new ModelImpl());
                }
            }
            return model;
        }
        sub = node.get("type");
        JsonNode items = node.get("items");
        Model model = null;
        model = sub != null && "array".equals(((TextNode)sub).textValue()) || items != null ? (Model)Json.mapper().convertValue((Object)node, ArrayModel.class) : (Model)Json.mapper().convertValue((Object)node, ModelImpl.class);
        return model;
    }
}

