/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.bootstrap;

import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.Internal;
import com.dataiku.dss.shadelib.org.apache.hc.core5.function.Callback;
import com.dataiku.dss.shadelib.org.apache.hc.core5.function.Resolver;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.ClassicHttpRequest;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.ClassicHttpResponse;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.ConnectionClosedException;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpException;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpHost;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.URIScheme;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.config.CharCodingConfig;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.config.Http1Config;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnectionFactory;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.EofSensorInputStream;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.EofSensorWatcher;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.HttpClientConnection;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.HttpClientResponseHandler;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.SocketConfig;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.io.ssl.SSLSessionVerifier;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.protocol.HttpContext;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.dataiku.dss.shadelib.org.apache.hc.core5.io.CloseMode;
import com.dataiku.dss.shadelib.org.apache.hc.core5.io.Closer;
import com.dataiku.dss.shadelib.org.apache.hc.core5.io.ModalCloseable;
import com.dataiku.dss.shadelib.org.apache.hc.core5.io.SocketSupport;
import com.dataiku.dss.shadelib.org.apache.hc.core5.net.URIAuthority;
import com.dataiku.dss.shadelib.org.apache.hc.core5.pool.ConnPoolControl;
import com.dataiku.dss.shadelib.org.apache.hc.core5.pool.ManagedConnPool;
import com.dataiku.dss.shadelib.org.apache.hc.core5.pool.PoolEntry;
import com.dataiku.dss.shadelib.org.apache.hc.core5.pool.PoolStats;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Args;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.TimeValue;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequester
implements ConnPoolControl<HttpHost>,
ModalCloseable {
    private final HttpRequestExecutor requestExecutor;
    private final HttpProcessor httpProcessor;
    private final ManagedConnPool<HttpHost, HttpClientConnection> connPool;
    private final SocketConfig socketConfig;
    private final HttpConnectionFactory<? extends HttpClientConnection> connectFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Callback<SSLParameters> sslSetupHandler;
    private final SSLSessionVerifier sslSessionVerifier;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public HttpRequester(HttpRequestExecutor requestExecutor, HttpProcessor httpProcessor, ManagedConnPool<HttpHost, HttpClientConnection> connPool, SocketConfig socketConfig, HttpConnectionFactory<? extends HttpClientConnection> connectFactory, SSLSocketFactory sslSocketFactory, Callback<SSLParameters> sslSetupHandler, SSLSessionVerifier sslSessionVerifier, Resolver<HttpHost, InetSocketAddress> addressResolver) {
        this.requestExecutor = Args.notNull(requestExecutor, "Request executor");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.connPool = Args.notNull(connPool, "Connection pool");
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.connectFactory = connectFactory != null ? connectFactory : new DefaultBHttpClientConnectionFactory(Http1Config.DEFAULT, CharCodingConfig.DEFAULT);
        this.sslSocketFactory = sslSocketFactory != null ? sslSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.sslSetupHandler = sslSetupHandler;
        this.sslSessionVerifier = sslSessionVerifier;
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    public PoolStats getTotalStats() {
        return this.connPool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpHost route) {
        return this.connPool.getStats(route);
    }

    @Override
    public void setMaxTotal(int max) {
        this.connPool.setMaxTotal(max);
    }

    @Override
    public int getMaxTotal() {
        return this.connPool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.connPool.setDefaultMaxPerRoute(max);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.connPool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(HttpHost route, int max) {
        this.connPool.setMaxPerRoute(route, max);
    }

    @Override
    public int getMaxPerRoute(HttpHost route) {
        return this.connPool.getMaxPerRoute(route);
    }

    @Override
    public void closeIdle(TimeValue idleTime) {
        this.connPool.closeIdle(idleTime);
    }

    @Override
    public void closeExpired() {
        this.connPool.closeExpired();
    }

    @Override
    public Set<HttpHost> getRoutes() {
        return this.connPool.getRoutes();
    }

    public ClassicHttpResponse execute(HttpClientConnection connection, ClassicHttpRequest request, HttpResponseInformationCallback informationCallback, HttpContext context) throws HttpException, IOException {
        Args.notNull(connection, "HTTP connection");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        if (!connection.isOpen()) {
            throw new ConnectionClosedException();
        }
        this.requestExecutor.preProcess(request, this.httpProcessor, context);
        ClassicHttpResponse response = this.requestExecutor.execute(request, connection, informationCallback, context);
        this.requestExecutor.postProcess(response, this.httpProcessor, context);
        return response;
    }

    public ClassicHttpResponse execute(HttpClientConnection connection, ClassicHttpRequest request, HttpContext context) throws HttpException, IOException {
        return this.execute(connection, request, null, context);
    }

    public boolean keepAlive(HttpClientConnection connection, ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws IOException {
        boolean keepAlive = this.requestExecutor.keepAlive(request, response, connection, context);
        if (!keepAlive) {
            connection.close();
        }
        return keepAlive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(HttpClientConnection connection, ClassicHttpRequest request, HttpContext context, HttpClientResponseHandler<T> responseHandler) throws HttpException, IOException {
        try (ClassicHttpResponse response = this.execute(connection, request, context);){
            T result = responseHandler.handleResponse(response);
            EntityUtils.consume(response.getEntity());
            boolean keepAlive = this.requestExecutor.keepAlive(request, response, connection, context);
            if (!keepAlive) {
                connection.close();
            }
            T t2 = result;
            return t2;
        }
        catch (HttpException | IOException | RuntimeException ex) {
            connection.close(CloseMode.IMMEDIATE);
            throw ex;
        }
    }

    private HttpClientConnection createConnection(Socket sock, HttpHost targetHost) throws IOException {
        int linger;
        sock.setSoTimeout(this.socketConfig.getSoTimeout().toMillisecondsIntBound());
        sock.setReuseAddress(this.socketConfig.isSoReuseAddress());
        sock.setTcpNoDelay(this.socketConfig.isTcpNoDelay());
        sock.setKeepAlive(this.socketConfig.isSoKeepAlive());
        if (this.socketConfig.getRcvBufSize() > 0) {
            sock.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
        }
        if (this.socketConfig.getSndBufSize() > 0) {
            sock.setSendBufferSize(this.socketConfig.getSndBufSize());
        }
        if (this.socketConfig.getTcpKeepIdle() > 0) {
            SocketSupport.setOption(sock, "TCP_KEEPIDLE", this.socketConfig.getTcpKeepIdle());
        }
        if (this.socketConfig.getTcpKeepInterval() > 0) {
            SocketSupport.setOption(sock, "TCP_KEEPINTERVAL", this.socketConfig.getTcpKeepInterval());
        }
        if (this.socketConfig.getTcpKeepCount() > 0) {
            SocketSupport.setOption(sock, "TCP_KEEPCOUNT", this.socketConfig.getTcpKeepCount());
        }
        if ((linger = this.socketConfig.getSoLinger().toMillisecondsIntBound()) >= 0) {
            sock.setSoLinger(true, linger);
        }
        InetSocketAddress targetAddress = this.addressResolver.resolve(targetHost);
        sock.connect(targetAddress, this.socketConfig.getSoTimeout().toMillisecondsIntBound());
        if (URIScheme.HTTPS.same(targetHost.getSchemeName())) {
            SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(sock, targetHost.getHostName(), targetAddress.getPort(), false);
            if (this.sslSetupHandler != null) {
                SSLParameters sslParameters = sslSocket.getSSLParameters();
                this.sslSetupHandler.execute(sslParameters);
                sslSocket.setSSLParameters(sslParameters);
            }
            try {
                sslSocket.startHandshake();
                SSLSession session = sslSocket.getSession();
                if (session == null) {
                    throw new SSLHandshakeException("SSL session not available");
                }
                if (this.sslSessionVerifier != null) {
                    this.sslSessionVerifier.verify(targetHost, session);
                }
                return this.connectFactory.createConnection(sslSocket, sock);
            }
            catch (IOException ex) {
                Closer.closeQuietly(sslSocket);
                throw ex;
            }
        }
        return this.connectFactory.createConnection(sock);
    }

    public ClassicHttpResponse execute(HttpHost targetHost, final ClassicHttpRequest request, HttpResponseInformationCallback informationCallback, Timeout connectTimeout, final HttpContext context) throws HttpException, IOException {
        PoolEntry<HttpHost, HttpClientConnection> poolEntry;
        Args.notNull(targetHost, "HTTP host");
        Args.notNull(request, "HTTP request");
        Future leaseFuture = this.connPool.lease(targetHost, null, connectTimeout, null);
        Timeout timeout = Timeout.defaultsToInfinite(connectTimeout);
        try {
            poolEntry = leaseFuture.get(timeout.getDuration(), timeout.getTimeUnit());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(ex.getMessage());
        }
        catch (ExecutionException ex) {
            throw new HttpException("Unexpected failure leasing connection", ex);
        }
        catch (TimeoutException ex) {
            throw new ConnectionRequestTimeoutException("Connection request timeout");
        }
        final PoolEntryHolder connectionHolder = new PoolEntryHolder(poolEntry);
        try {
            ClassicHttpResponse response;
            HttpEntity entity;
            HttpClientConnection connection = poolEntry.getConnection();
            if (connection == null) {
                Socket sock = this.socketConfig.getSocksProxyAddress() != null ? new Socket(new Proxy(Proxy.Type.SOCKS, this.socketConfig.getSocksProxyAddress())) : new Socket();
                try {
                    connection = this.createConnection(sock, targetHost);
                    poolEntry.assignConnection(connection);
                }
                catch (IOException | RuntimeException ex) {
                    Closer.closeQuietly(sock);
                    throw ex;
                }
            }
            if (request.getAuthority() == null) {
                request.setAuthority(new URIAuthority(targetHost.getHostName(), targetHost.getPort()));
            }
            if ((entity = (response = this.execute(connection, request, informationCallback, context)).getEntity()) != null) {
                response.setEntity(new HttpEntityWrapper(entity){

                    private void releaseConnection() throws IOException {
                        try {
                            HttpClientConnection localConn = connectionHolder.getConnection();
                            if (localConn != null && HttpRequester.this.requestExecutor.keepAlive(request, response, localConn, context)) {
                                if (super.isStreaming()) {
                                    Closer.close(super.getContent());
                                }
                                connectionHolder.releaseConnection();
                            }
                        }
                        finally {
                            connectionHolder.discardConnection();
                        }
                    }

                    private void abortConnection() {
                        connectionHolder.discardConnection();
                    }

                    @Override
                    public boolean isStreaming() {
                        return true;
                    }

                    @Override
                    public InputStream getContent() throws IOException {
                        return new EofSensorInputStream(super.getContent(), new EofSensorWatcher(){

                            @Override
                            public boolean eofDetected(InputStream wrapped) throws IOException {
                                this.releaseConnection();
                                return false;
                            }

                            @Override
                            public boolean streamClosed(InputStream wrapped) throws IOException {
                                this.releaseConnection();
                                return false;
                            }

                            @Override
                            public boolean streamAbort(InputStream wrapped) throws IOException {
                                this.abortConnection();
                                return false;
                            }
                        });
                    }

                    @Override
                    public void writeTo(OutputStream outStream) throws IOException {
                        try {
                            if (outStream != null) {
                                super.writeTo(outStream);
                            }
                            this.close();
                        }
                        catch (IOException | RuntimeException ex) {
                            this.abortConnection();
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        this.releaseConnection();
                    }
                });
            } else {
                HttpClientConnection localConn = connectionHolder.getConnection();
                if (!this.requestExecutor.keepAlive(request, response, localConn, context)) {
                    localConn.close();
                }
                connectionHolder.releaseConnection();
            }
            return response;
        }
        catch (HttpException | IOException | RuntimeException ex) {
            connectionHolder.discardConnection();
            throw ex;
        }
    }

    public ClassicHttpResponse execute(HttpHost targetHost, ClassicHttpRequest request, Timeout connectTimeout, HttpContext context) throws HttpException, IOException {
        return this.execute(targetHost, request, null, connectTimeout, context);
    }

    public <T> T execute(HttpHost targetHost, ClassicHttpRequest request, Timeout connectTimeout, HttpContext context, HttpClientResponseHandler<T> responseHandler) throws HttpException, IOException {
        try (ClassicHttpResponse response = this.execute(targetHost, request, null, connectTimeout, context);){
            T result = responseHandler.handleResponse(response);
            EntityUtils.consume(response.getEntity());
            T t2 = result;
            return t2;
        }
    }

    public ConnPoolControl<HttpHost> getConnPoolControl() {
        return this.connPool;
    }

    @Override
    public void close(CloseMode closeMode) {
        this.connPool.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.connPool.close();
    }

    private class PoolEntryHolder {
        private final AtomicReference<PoolEntry<HttpHost, HttpClientConnection>> poolEntryRef;

        PoolEntryHolder(PoolEntry<HttpHost, HttpClientConnection> poolEntry) {
            this.poolEntryRef = new AtomicReference<PoolEntry<HttpHost, HttpClientConnection>>(poolEntry);
        }

        HttpClientConnection getConnection() {
            PoolEntry<HttpHost, HttpClientConnection> poolEntry = this.poolEntryRef.get();
            return poolEntry != null ? poolEntry.getConnection() : null;
        }

        void releaseConnection() {
            PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
            if (poolEntry != null) {
                HttpClientConnection connection = (HttpClientConnection)poolEntry.getConnection();
                HttpRequester.this.connPool.release(poolEntry, connection != null && connection.isOpen());
            }
        }

        void discardConnection() {
            PoolEntry poolEntry = this.poolEntryRef.getAndSet(null);
            if (poolEntry != null) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
                HttpRequester.this.connPool.release(poolEntry, false);
            }
        }
    }
}

