/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseFileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseFilesTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetricsUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Partitioning;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Binder;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionVisitors;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ManifestEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ResidualEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructProjection;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class BaseEntriesTable
extends BaseMetadataTable {
    BaseEntriesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().isEmpty()) {
            schema = TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return TypeUtil.join(schema, MetricsUtil.readableMetricsSchema(this.table().schema(), schema));
    }

    static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        LoadingCache evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter(rowFilter, transformedSpec, caseSensitive);
        });
        ManifestContentEvaluator manifestContentEvaluator = new ManifestContentEvaluator(filter, tableSchema.asStruct(), caseSensitive);
        CloseableIterable<ManifestFile> filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval((ManifestFile)manifest) && manifestContentEvaluator.eval((ManifestFile)manifest));
        return CloseableIterable.transform(filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, filter));
    }

    private static class ManifestContentEvaluator {
        private final Expression boundExpr;

        private ManifestContentEvaluator(Expression expr, Types.StructType structType, boolean caseSensitive) {
            Expression rewritten = Expressions.rewriteNot(expr);
            this.boundExpr = Binder.bind(structType, rewritten, caseSensitive);
        }

        private boolean eval(ManifestFile manifest) {
            return new ManifestEvalVisitor().eval(manifest);
        }

        private class ManifestEvalVisitor
        extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
            private int manifestContentId;
            private static final boolean ROWS_MIGHT_MATCH = true;
            private static final boolean ROWS_CANNOT_MATCH = false;

            private ManifestEvalVisitor() {
            }

            private boolean eval(ManifestFile manifestFile) {
                this.manifestContentId = manifestFile.content().id();
                return ExpressionVisitors.visitEvaluator(ManifestContentEvaluator.this.boundExpr, this);
            }

            @Override
            public Boolean alwaysTrue() {
                return true;
            }

            @Override
            public Boolean alwaysFalse() {
                return false;
            }

            @Override
            public Boolean not(Boolean result) {
                return result == false;
            }

            @Override
            public Boolean and(Boolean leftResult, Boolean rightResult) {
                return leftResult != false && rightResult != false;
            }

            @Override
            public Boolean or(Boolean leftResult, Boolean rightResult) {
                return leftResult != false || rightResult != false;
            }

            @Override
            public <T> Boolean isNull(BoundReference<T> ref) {
                if (this.fileContent(ref)) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notNull(BoundReference<T> ref) {
                return true;
            }

            @Override
            public <T> Boolean isNaN(BoundReference<T> ref) {
                if (this.fileContent(ref)) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notNaN(BoundReference<T> ref) {
                return true;
            }

            @Override
            public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            @Override
            public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            @Override
            public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            @Override
            public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            @Override
            public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
                Literal intLit;
                if (this.fileContent(ref) && !this.contentMatch((Integer)(intLit = lit.to(Types.IntegerType.get())).value())) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
                Literal intLit;
                if (this.fileContent(ref) && this.contentMatch((Integer)(intLit = lit.to(Types.IntegerType.get())).value())) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
                if (this.fileContent(ref) && literalSet.stream().noneMatch(lit -> this.contentMatch((Integer)lit))) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
                if (this.fileContent(ref) && literalSet.stream().anyMatch(lit -> this.contentMatch((Integer)lit))) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            @Override
            public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            private <T> boolean fileContent(BoundReference<T> ref) {
                return ref.fieldId() == DataFile.CONTENT.fieldId();
            }

            private boolean contentMatch(Integer fileContentId) {
                if (FileContent.DATA.id() == fileContentId.intValue()) {
                    return ManifestContent.DATA.id() == this.manifestContentId;
                }
                if (FileContent.EQUALITY_DELETES.id() == fileContentId.intValue() || FileContent.POSITION_DELETES.id() == fileContentId.intValue()) {
                    return ManifestContent.DELETES.id() == this.manifestContentId;
                }
                return false;
            }
        }
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema projection;
        private final Schema fileProjection;
        private final Schema dataTableSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        private ManifestReadTask(Table table, ManifestFile manifest, Schema projection, Expression filter) {
            this(table.schema(), table.io(), table.specs(), manifest, projection, filter);
        }

        ManifestReadTask(Schema dataTableSchema, FileIO io, Map<Integer, PartitionSpec> specsById, ManifestFile manifest, Schema projection, Expression filter) {
            super(DataFiles.fromManifest(manifest), null, SchemaParser.toJson(projection), PartitionSpecParser.toJson(PartitionSpec.unpartitioned()), ResidualEvaluator.unpartitioned(filter));
            this.projection = projection;
            this.io = io;
            this.manifest = manifest;
            this.specsById = Maps.newHashMap(specsById);
            this.dataTableSchema = dataTableSchema;
            Type fileProjectionType = projection.findType("data_file");
            this.fileProjection = fileProjectionType != null ? new Schema(fileProjectionType.asStructType().fields()) : new Schema(new Types.NestedField[0]);
        }

        @Override
        public long estimatedRowsCount() {
            return (long)this.manifest.addedFilesCount().intValue() + (long)this.manifest.deletedFilesCount().intValue() + (long)this.manifest.existingFilesCount().intValue();
        }

        ManifestFile manifest() {
            return this.manifest;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            Types.NestedField readableMetricsField = this.projection.findField("readable_metrics");
            if (readableMetricsField == null) {
                StructProjection structProjection = this.structProjection(this.projection);
                return CloseableIterable.transform(this.entries(this.fileProjection), entry -> structProjection.wrap((StructLike)((Object)entry)));
            }
            Schema requiredFileProjection = this.requiredFileProjection();
            Schema actualProjection = this.removeReadableMetrics(this.projection, readableMetricsField);
            StructProjection structProjection = this.structProjection(actualProjection);
            return CloseableIterable.transform(this.entries(requiredFileProjection), entry -> this.withReadableMetrics(structProjection, (ManifestEntry<? extends ContentFile<?>>)entry, readableMetricsField));
        }

        private Schema requiredFileProjection() {
            Schema projectionForReadableMetrics = new Schema(MetricsUtil.READABLE_METRIC_COLS.stream().map(MetricsUtil.ReadableMetricColDefinition::originalCol).collect(Collectors.toList()));
            return TypeUtil.join(this.fileProjection, projectionForReadableMetrics);
        }

        private Schema removeReadableMetrics(Schema projectionSchema, Types.NestedField readableMetricsField) {
            Set<Integer> readableMetricsIds = TypeUtil.getProjectedIds(readableMetricsField.type());
            return TypeUtil.selectNot(projectionSchema, readableMetricsIds);
        }

        private StructProjection structProjection(Schema projectedSchema) {
            Schema manifestEntrySchema = ManifestEntry.wrapFileSchema(this.fileProjection.asStruct());
            return StructProjection.create(manifestEntrySchema, projectedSchema);
        }

        private CloseableIterable<? extends ManifestEntry<? extends ContentFile<?>>> entries(Schema fileStructProjection) {
            return ManifestFiles.open(this.manifest, this.io, this.specsById).project(fileStructProjection).entries();
        }

        private StructLike withReadableMetrics(StructProjection structProjection, ManifestEntry<? extends ContentFile<?>> entry, Types.NestedField readableMetricsField) {
            StructProjection struct = structProjection.wrap((StructLike)((Object)entry));
            int structSize = this.projection.columns().size();
            MetricsUtil.ReadableMetricsStruct readableMetrics = this.readableMetrics(entry.file(), readableMetricsField);
            int metricsPosition = this.projection.columns().indexOf(readableMetricsField);
            return new MetricsUtil.StructWithReadableMetrics(struct, structSize, readableMetrics, metricsPosition);
        }

        private MetricsUtil.ReadableMetricsStruct readableMetrics(ContentFile<?> file, Types.NestedField readableMetricsField) {
            Types.StructType projectedMetricType = readableMetricsField.type().asStructType();
            return MetricsUtil.readableMetricsStruct(this.dataTableSchema, file, projectedMetricType);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }

        FileIO io() {
            return this.io;
        }

        Map<Integer, PartitionSpec> specsById() {
            return this.specsById;
        }

        Schema dataTableSchema() {
            return this.dataTableSchema;
        }

        Schema projection() {
            return this.projection;
        }
    }
}

