/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseIncrementalScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.CombinedScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalAppendScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SnapshotUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.TableScanUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class BaseIncrementalAppendScan
extends BaseIncrementalScan<IncrementalAppendScan, FileScanTask, CombinedScanTask>
implements IncrementalAppendScan {
    BaseIncrementalAppendScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    protected IncrementalAppendScan newRefinedScan(Table newTable, Schema newSchema, TableScanContext newContext) {
        return new BaseIncrementalAppendScan(newTable, newSchema, newContext);
    }

    @Override
    protected CloseableIterable<FileScanTask> doPlanFiles(Long fromSnapshotIdExclusive, long toSnapshotIdInclusive) {
        List<Snapshot> snapshots = BaseIncrementalAppendScan.appendsBetween(this.table(), fromSnapshotIdExclusive, toSnapshotIdInclusive);
        if (snapshots.isEmpty()) {
            return CloseableIterable.empty();
        }
        return this.appendFilesFromSnapshots(snapshots);
    }

    @Override
    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, this.targetSplitSize());
        return TableScanUtil.planTasks(splitFiles, this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    private CloseableIterable<FileScanTask> appendFilesFromSnapshots(List<Snapshot> snapshots) {
        HashSet snapshotIds = Sets.newHashSet(Iterables.transform(snapshots, Snapshot::snapshotId));
        ImmutableSet<ManifestFile> manifests = FluentIterable.from(snapshots).transformAndConcat(snapshot -> snapshot.dataManifests(this.table().io())).filter(manifestFile -> snapshotIds.contains(manifestFile.snapshotId())).toSet();
        ManifestGroup manifestGroup = new ManifestGroup(this.table().io(), manifests).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterData(this.filter()).filterManifestEntries(manifestEntry -> snapshotIds.contains(manifestEntry.snapshotId()) && manifestEntry.status() == ManifestEntry.Status.ADDED).specsById(this.table().specs()).ignoreDeleted().columnsToKeepStats(this.columnsToKeepStats());
        if (this.context().ignoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (manifests.size() > 1 && this.shouldPlanWithExecutor()) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.planFiles();
    }

    private static List<Snapshot> appendsBetween(Table table, Long fromSnapshotIdExclusive, long toSnapshotIdInclusive) {
        ArrayList<Snapshot> snapshots = Lists.newArrayList();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween(toSnapshotIdInclusive, fromSnapshotIdExclusive, table::snapshot)) {
            if (!snapshot.operation().equals("append")) continue;
            snapshots.add(snapshot);
        }
        return snapshots;
    }
}

