/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.AppendFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseIncrementalAppendScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseIncrementalChangelogScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseOverwriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseReplacePartitions;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseReplaceSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseRewriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseRewriteManifests;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseRowDelta;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseUpdatePartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.ExpireSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.FastAppend;
import com.dataiku.dss.shadelib.org.apache.iceberg.HasTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.HistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ImmutableTableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalAppendScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalChangelogScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManageSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.MergeAppend;
import com.dataiku.dss.shadelib.org.apache.iceberg.OverwriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PropertiesUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.RemoveSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.ReplacePartitions;
import com.dataiku.dss.shadelib.org.apache.iceberg.ReplaceSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteManifests;
import com.dataiku.dss.shadelib.org.apache.iceberg.RowDelta;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.SerializableTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.SetLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.SetPartitionStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.SetStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotRef;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.StatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.StreamingDelete;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.Transaction;
import com.dataiku.dss.shadelib.org.apache.iceberg.Transactions;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdatePartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdatePartitionStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateProperties;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateSchema;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.LocationProvider;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.LoggingMetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BaseTable
implements Table,
HasTableOperations,
Serializable {
    private final TableOperations ops;
    private final String name;
    private final MetricsReporter reporter;

    public BaseTable(TableOperations ops, String name) {
        this(ops, name, LoggingMetricsReporter.instance());
    }

    public BaseTable(TableOperations ops, String name, MetricsReporter reporter) {
        Preconditions.checkNotNull(reporter, "reporter cannot be null");
        this.ops = ops;
        this.name = name;
        this.reporter = reporter;
    }

    public MetricsReporter reporter() {
        return this.reporter;
    }

    @Override
    public TableOperations operations() {
        return this.ops;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void refresh() {
        this.ops.refresh();
    }

    @Override
    public TableScan newScan() {
        return new DataTableScan(this, this.schema(), ImmutableTableScanContext.builder().metricsReporter(this.reporter).build());
    }

    @Override
    public IncrementalAppendScan newIncrementalAppendScan() {
        return new BaseIncrementalAppendScan(this, this.schema(), ImmutableTableScanContext.builder().metricsReporter(this.reporter).build());
    }

    @Override
    public IncrementalChangelogScan newIncrementalChangelogScan() {
        return new BaseIncrementalChangelogScan(this);
    }

    @Override
    public Schema schema() {
        return this.ops.current().schema();
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return this.ops.current().schemasById();
    }

    @Override
    public PartitionSpec spec() {
        return this.ops.current().spec();
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.ops.current().specsById();
    }

    @Override
    public SortOrder sortOrder() {
        return this.ops.current().sortOrder();
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return this.ops.current().sortOrdersById();
    }

    @Override
    public Map<String, String> properties() {
        return this.ops.current().properties();
    }

    @Override
    public String location() {
        return this.ops.current().location();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.ops.current().currentSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.ops.current().snapshot(snapshotId);
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.ops.current().snapshots();
    }

    @Override
    public List<HistoryEntry> history() {
        return this.ops.current().snapshotLog();
    }

    @Override
    public UpdateSchema updateSchema() {
        return new SchemaUpdate(this.ops);
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        return new BaseUpdatePartitionSpec(this.ops);
    }

    @Override
    public UpdateProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        return new BaseReplaceSortOrder(this.ops);
    }

    @Override
    public UpdateLocation updateLocation() {
        return new SetLocation(this.ops);
    }

    @Override
    public AppendFiles newAppend() {
        return (AppendFiles)new MergeAppend(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public AppendFiles newFastAppend() {
        return (AppendFiles)new FastAppend(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public RewriteFiles newRewrite() {
        return (RewriteFiles)new BaseRewriteFiles(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public RewriteManifests rewriteManifests() {
        return (RewriteManifests)new BaseRewriteManifests(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public OverwriteFiles newOverwrite() {
        return (OverwriteFiles)new BaseOverwriteFiles(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public RowDelta newRowDelta() {
        return (RowDelta)new BaseRowDelta(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        return (ReplacePartitions)new BaseReplacePartitions(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public DeleteFiles newDelete() {
        return (DeleteFiles)new StreamingDelete(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public UpdateStatistics updateStatistics() {
        return new SetStatistics(this.ops);
    }

    @Override
    public UpdatePartitionStatistics updatePartitionStatistics() {
        return new SetPartitionStatistics(this.ops);
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        return new RemoveSnapshots(this.ops);
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        return new SnapshotManager(this.name, this.ops, this.reporter);
    }

    @Override
    public Transaction newTransaction() {
        return Transactions.newTransaction(this.name, this.ops, this.reporter);
    }

    @Override
    public FileIO io() {
        return this.ops.io();
    }

    @Override
    public EncryptionManager encryption() {
        return this.ops.encryption();
    }

    @Override
    public LocationProvider locationProvider() {
        return this.ops.locationProvider();
    }

    @Override
    public List<StatisticsFile> statisticsFiles() {
        return this.ops.current().statisticsFiles();
    }

    @Override
    public List<PartitionStatisticsFile> partitionStatisticsFiles() {
        return this.ops.current().partitionStatisticsFiles();
    }

    @Override
    public Map<String, SnapshotRef> refs() {
        return this.ops.current().refs();
    }

    @Override
    public UUID uuid() {
        return UUID.fromString(this.ops.current().uuid());
    }

    public String toString() {
        return this.name();
    }

    Object writeReplace() {
        return SerializableTable.copyOf(this);
    }
}

