/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.List;

public interface DataFile
extends ContentFile<DataFile> {
    public static final Types.NestedField CONTENT = Types.NestedField.optional(134, "content", Types.IntegerType.get(), "Contents of the file: 0=data, 1=position deletes, 2=equality deletes");
    public static final Types.NestedField FILE_PATH = Types.NestedField.required(100, "file_path", Types.StringType.get(), "Location URI with FS scheme");
    public static final Types.NestedField FILE_FORMAT = Types.NestedField.required(101, "file_format", Types.StringType.get(), "File format name: avro, orc, or parquet");
    public static final Types.NestedField RECORD_COUNT = Types.NestedField.required(103, "record_count", Types.LongType.get(), "Number of records in the file");
    public static final Types.NestedField FILE_SIZE = Types.NestedField.required(104, "file_size_in_bytes", Types.LongType.get(), "Total file size in bytes");
    public static final Types.NestedField COLUMN_SIZES = Types.NestedField.optional(108, "column_sizes", Types.MapType.ofRequired(117, 118, Types.IntegerType.get(), Types.LongType.get()), "Map of column id to total size on disk");
    public static final Types.NestedField VALUE_COUNTS = Types.NestedField.optional(109, "value_counts", Types.MapType.ofRequired(119, 120, Types.IntegerType.get(), Types.LongType.get()), "Map of column id to total count, including null and NaN");
    public static final Types.NestedField NULL_VALUE_COUNTS = Types.NestedField.optional(110, "null_value_counts", Types.MapType.ofRequired(121, 122, Types.IntegerType.get(), Types.LongType.get()), "Map of column id to null value count");
    public static final Types.NestedField NAN_VALUE_COUNTS = Types.NestedField.optional(137, "nan_value_counts", Types.MapType.ofRequired(138, 139, Types.IntegerType.get(), Types.LongType.get()), "Map of column id to number of NaN values in the column");
    public static final Types.NestedField LOWER_BOUNDS = Types.NestedField.optional(125, "lower_bounds", Types.MapType.ofRequired(126, 127, Types.IntegerType.get(), Types.BinaryType.get()), "Map of column id to lower bound");
    public static final Types.NestedField UPPER_BOUNDS = Types.NestedField.optional(128, "upper_bounds", Types.MapType.ofRequired(129, 130, Types.IntegerType.get(), Types.BinaryType.get()), "Map of column id to upper bound");
    public static final Types.NestedField KEY_METADATA = Types.NestedField.optional(131, "key_metadata", Types.BinaryType.get(), "Encryption key metadata blob");
    public static final Types.NestedField SPLIT_OFFSETS = Types.NestedField.optional(132, "split_offsets", Types.ListType.ofRequired(133, Types.LongType.get()), "Splittable offsets");
    public static final Types.NestedField EQUALITY_IDS = Types.NestedField.optional(135, "equality_ids", Types.ListType.ofRequired(136, Types.IntegerType.get()), "Equality comparison field IDs");
    public static final Types.NestedField SORT_ORDER_ID = Types.NestedField.optional(140, "sort_order_id", Types.IntegerType.get(), "Sort order ID");
    public static final Types.NestedField SPEC_ID = Types.NestedField.optional(141, "spec_id", Types.IntegerType.get(), "Partition spec ID");
    public static final Types.NestedField FIRST_ROW_ID = Types.NestedField.optional(142, "first_row_id", Types.LongType.get(), "The first row ID assigned to the first row in the data file");
    public static final Types.NestedField REFERENCED_DATA_FILE = Types.NestedField.optional(143, "referenced_data_file", Types.StringType.get(), "Fully qualified location (URI with FS scheme) of a data file that all deletes reference");
    public static final Types.NestedField CONTENT_OFFSET = Types.NestedField.optional(144, "content_offset", Types.LongType.get(), "The offset in the file where the content starts");
    public static final Types.NestedField CONTENT_SIZE = Types.NestedField.optional(145, "content_size_in_bytes", Types.LongType.get(), "The length of referenced content stored in the file");
    public static final int PARTITION_ID = 102;
    public static final String PARTITION_NAME = "partition";
    public static final String PARTITION_DOC = "Partition data tuple, schema based on the partition spec";

    public static Types.StructType getType(Types.StructType partitionType) {
        return Types.StructType.of(CONTENT, FILE_PATH, FILE_FORMAT, SPEC_ID, Types.NestedField.required(102, PARTITION_NAME, partitionType, PARTITION_DOC), RECORD_COUNT, FILE_SIZE, COLUMN_SIZES, VALUE_COUNTS, NULL_VALUE_COUNTS, NAN_VALUE_COUNTS, LOWER_BOUNDS, UPPER_BOUNDS, KEY_METADATA, SPLIT_OFFSETS, EQUALITY_IDS, SORT_ORDER_ID, FIRST_ROW_ID, REFERENCED_DATA_FILE, CONTENT_OFFSET, CONTENT_SIZE);
    }

    @Override
    default public FileContent content() {
        return FileContent.DATA;
    }

    @Override
    default public List<Integer> equalityFieldIds() {
        return null;
    }
}

