/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class Metrics
implements Serializable {
    private Long rowCount = null;
    private Map<Integer, Long> columnSizes = null;
    private Map<Integer, Long> valueCounts = null;
    private Map<Integer, Long> nullValueCounts = null;
    private Map<Integer, Long> nanValueCounts = null;
    private Map<Integer, ByteBuffer> lowerBounds = null;
    private Map<Integer, ByteBuffer> upperBounds = null;
    private Map<Integer, Type> originalTypes = null;

    public Metrics() {
    }

    public Metrics(long rowCount) {
        this.rowCount = rowCount;
    }

    public Metrics(Long rowCount, Map<Integer, Long> columnSizes, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts) {
        this(rowCount, columnSizes, valueCounts, nullValueCounts, nanValueCounts, null, null, null);
    }

    public Metrics(Long rowCount, Map<Integer, Long> columnSizes, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts, Map<Integer, ByteBuffer> lowerBounds, Map<Integer, ByteBuffer> upperBounds) {
        this(rowCount, columnSizes, valueCounts, nullValueCounts, nanValueCounts, lowerBounds, upperBounds, null);
    }

    public Metrics(Long rowCount, Map<Integer, Long> columnSizes, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts, Map<Integer, ByteBuffer> lowerBounds, Map<Integer, ByteBuffer> upperBounds, Map<Integer, Type> originalTypes) {
        this.rowCount = rowCount;
        this.columnSizes = columnSizes;
        this.valueCounts = valueCounts;
        this.nullValueCounts = nullValueCounts;
        this.nanValueCounts = nanValueCounts;
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        this.originalTypes = originalTypes;
    }

    public Long recordCount() {
        return this.rowCount;
    }

    public Map<Integer, Long> columnSizes() {
        return this.columnSizes;
    }

    public Map<Integer, Long> valueCounts() {
        return this.valueCounts;
    }

    public Map<Integer, Long> nullValueCounts() {
        return this.nullValueCounts;
    }

    public Map<Integer, Long> nanValueCounts() {
        return this.nanValueCounts;
    }

    public Map<Integer, ByteBuffer> lowerBounds() {
        return this.lowerBounds;
    }

    public Map<Integer, ByteBuffer> upperBounds() {
        return this.upperBounds;
    }

    Map<Integer, Type> originalTypes() {
        return this.originalTypes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.rowCount);
        out.writeObject(this.columnSizes);
        out.writeObject(this.valueCounts);
        out.writeObject(this.nullValueCounts);
        out.writeObject(this.nanValueCounts);
        Metrics.writeByteBufferMap(out, this.lowerBounds);
        Metrics.writeByteBufferMap(out, this.upperBounds);
    }

    private static void writeByteBufferMap(ObjectOutputStream out, Map<Integer, ByteBuffer> byteBufferMap) throws IOException {
        if (byteBufferMap == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(byteBufferMap.size());
            for (Map.Entry<Integer, ByteBuffer> entry : byteBufferMap.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(ByteBuffers.toByteArray(entry.getValue()));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.rowCount = (Long)in.readObject();
        this.columnSizes = (Map)in.readObject();
        this.valueCounts = (Map)in.readObject();
        this.nullValueCounts = (Map)in.readObject();
        this.nanValueCounts = (Map)in.readObject();
        this.lowerBounds = Metrics.readByteBufferMap(in);
        this.upperBounds = Metrics.readByteBufferMap(in);
    }

    private static Map<Integer, ByteBuffer> readByteBufferMap(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<Integer, ByteBuffer> result = Maps.newHashMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            Integer key = (Integer)in.readObject();
            byte[] data = (byte[])in.readObject();
            if (data != null) {
                result.put(key, ByteBuffer.wrap(data));
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

