/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.SplitScanTaskIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ArrayUtil;
import java.util.List;
import java.util.NoSuchElementException;

class OffsetsAwareSplitScanTaskIterator<T extends ScanTask>
implements SplitScanTaskIterator<T> {
    private final T parentTask;
    private final SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator;
    private final long[] offsets;
    private final long[] splitSizes;
    private int splitIndex = 0;

    OffsetsAwareSplitScanTaskIterator(T parentTask, long parentTaskLength, List<Long> offsets, SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator) {
        this(parentTask, parentTaskLength, ArrayUtil.toLongArray(offsets), splitTaskCreator);
    }

    OffsetsAwareSplitScanTaskIterator(T parentTask, long parentTaskLength, long[] offsets, SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator) {
        this.parentTask = parentTask;
        this.splitTaskCreator = splitTaskCreator;
        this.offsets = offsets;
        this.splitSizes = new long[offsets.length];
        if (offsets.length > 0) {
            int lastIndex = offsets.length - 1;
            for (int index = 0; index < lastIndex; ++index) {
                this.splitSizes[index] = offsets[index + 1] - offsets[index];
            }
            this.splitSizes[lastIndex] = parentTaskLength - offsets[lastIndex];
        }
    }

    @Override
    public boolean hasNext() {
        return this.splitIndex < this.splitSizes.length;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long offset = this.offsets[this.splitIndex];
        long splitSize = this.splitSizes[this.splitIndex];
        ++this.splitIndex;
        return this.splitTaskCreator.create(this.parentTask, offset, splitSize);
    }
}

