/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionData;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStats;
import com.dataiku.dss.shadelib.org.apache.iceberg.Partitioning;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Queues;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Comparators;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PartitionMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PartitionUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@Deprecated
public class PartitionStatsUtil {
    private PartitionStatsUtil() {
    }

    public static Collection<PartitionStats> computeStats(Table table, Snapshot snapshot) {
        Preconditions.checkArgument(table != null, "table cannot be null");
        Preconditions.checkArgument(Partitioning.isPartitioned(table), "table must be partitioned");
        Preconditions.checkArgument(snapshot != null, "snapshot cannot be null");
        Types.StructType partitionType = Partitioning.partitionType(table);
        List<ManifestFile> manifests = snapshot.allManifests(table.io());
        ConcurrentLinkedQueue<PartitionMap<PartitionStats>> statsByManifest = Queues.newConcurrentLinkedQueue();
        Tasks.foreach(manifests).stopOnFailure().throwFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).run(manifest -> statsByManifest.add(PartitionStatsUtil.collectStats(table, manifest, partitionType)));
        return PartitionStatsUtil.mergeStats(statsByManifest, table.specs());
    }

    public static List<PartitionStats> sortStats(Collection<PartitionStats> stats, Types.StructType partitionType) {
        ArrayList<PartitionStats> entries = Lists.newArrayList(stats);
        entries.sort(PartitionStatsUtil.partitionStatsCmp(partitionType));
        return entries;
    }

    private static Comparator<PartitionStats> partitionStatsCmp(Types.StructType partitionType) {
        return Comparator.comparing(PartitionStats::partition, Comparators.forType(partitionType));
    }

    private static PartitionMap<PartitionStats> collectStats(Table table, ManifestFile manifest, Types.StructType partitionType) {
        PartitionMap partitionMap;
        block10: {
            ManifestReader<?> reader = PartitionStatsUtil.openManifest(table, manifest);
            try {
                PartitionMap statsMap = PartitionMap.create(table.specs());
                int specId = manifest.partitionSpecId();
                PartitionSpec spec = table.specs().get(specId);
                PartitionData keyTemplate = new PartitionData(partitionType);
                for (ManifestEntry manifestEntry : reader.entries()) {
                    Object file = manifestEntry.file();
                    StructLike coercedPartition = PartitionUtil.coercePartition(partitionType, spec, file.partition());
                    PartitionData key = keyTemplate.copyFor(coercedPartition);
                    Snapshot snapshot = table.snapshot(manifestEntry.snapshotId());
                    PartitionStats stats = statsMap.computeIfAbsent(specId, ((PartitionData)file.partition()).copy(), () -> new PartitionStats(key, specId));
                    if (manifestEntry.isLive()) {
                        stats.liveEntry((ContentFile<?>)file, snapshot);
                        continue;
                    }
                    stats.deletedEntry(snapshot);
                }
                partitionMap = statsMap;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return partitionMap;
    }

    private static ManifestReader<?> openManifest(Table table, ManifestFile manifest) {
        List<String> projection = BaseScan.scanColumns(manifest.content());
        return ManifestFiles.open(manifest, table.io()).select(projection);
    }

    private static Collection<PartitionStats> mergeStats(Queue<PartitionMap<PartitionStats>> statsByManifest, Map<Integer, PartitionSpec> specs) {
        PartitionMap statsMap = PartitionMap.create(specs);
        for (PartitionMap partitionMap : statsByManifest) {
            partitionMap.forEach((key, value) -> statsMap.merge(key, value, (existingEntry, newEntry) -> {
                existingEntry.appendStats((PartitionStats)newEntry);
                return existingEntry;
            }));
        }
        return statsMap.values();
    }
}

