/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.HasTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadataParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReachableFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReachableFileUtil.class);
    private static final String METADATA_FOLDER_NAME = "metadata";

    private ReachableFileUtil() {
    }

    public static String versionHintLocation(Table table) {
        Path metadataPath = new Path(table.location() + "/metadata");
        Path versionHintPath = new Path(String.valueOf(metadataPath) + "/version-hint.text");
        return versionHintPath.toString();
    }

    public static Set<String> metadataFileLocations(Table table, boolean recursive) {
        HashSet<String> metadataFileLocations = Sets.newHashSet();
        TableOperations ops = ((HasTableOperations)((Object)table)).operations();
        TableMetadata tableMetadata = ops.current();
        metadataFileLocations.add(tableMetadata.metadataFileLocation());
        ReachableFileUtil.metadataFileLocations(tableMetadata, metadataFileLocations, ops.io(), recursive);
        return metadataFileLocations;
    }

    private static void metadataFileLocations(TableMetadata metadata, Set<String> metadataFileLocations, FileIO io, boolean recursive) {
        List<TableMetadata.MetadataLogEntry> metadataLogEntries = metadata.previousFiles();
        if (!metadataLogEntries.isEmpty()) {
            TableMetadata previousMetadata;
            for (TableMetadata.MetadataLogEntry metadataLogEntry : metadataLogEntries) {
                metadataFileLocations.add(metadataLogEntry.file());
            }
            if (recursive && (previousMetadata = ReachableFileUtil.findFirstExistentPreviousMetadata(metadataLogEntries, io)) != null) {
                ReachableFileUtil.metadataFileLocations(previousMetadata, metadataFileLocations, io, recursive);
            }
        }
    }

    private static TableMetadata findFirstExistentPreviousMetadata(List<TableMetadata.MetadataLogEntry> metadataLogEntries, FileIO io) {
        TableMetadata metadata = null;
        for (TableMetadata.MetadataLogEntry metadataLogEntry : metadataLogEntries) {
            try {
                metadata = TableMetadataParser.read(io, metadataLogEntry.file());
                break;
            }
            catch (Exception e) {
                LOG.error("Failed to load {}", (Object)metadataLogEntry, (Object)e);
            }
        }
        return metadata;
    }

    public static List<String> manifestListLocations(Table table) {
        return ReachableFileUtil.manifestListLocations(table, null);
    }

    public static List<String> manifestListLocations(Table table, Set<Long> snapshotIds) {
        Iterable<Snapshot> snapshots = table.snapshots();
        if (snapshotIds != null) {
            snapshots = Iterables.filter(snapshots, s2 -> snapshotIds.contains(s2.snapshotId()));
        }
        ArrayList<String> manifestListLocations = Lists.newArrayList();
        for (Snapshot snapshot : snapshots) {
            String manifestListLocation = snapshot.manifestListLocation();
            if (manifestListLocation == null) continue;
            manifestListLocations.add(manifestListLocation);
        }
        return manifestListLocations;
    }

    public static List<String> statisticsFilesLocations(Table table) {
        return ReachableFileUtil.statisticsFilesLocationsForSnapshots(table, null);
    }

    public static List<String> statisticsFilesLocationsForSnapshots(Table table, Set<Long> snapshotIds) {
        Predicate<PartitionStatisticsFile> partitionStatsFilePredicate;
        Predicate<StatisticsFile> statsFilePredicate;
        ArrayList<String> statsFileLocations = Lists.newArrayList();
        if (snapshotIds == null) {
            statsFilePredicate = file -> true;
            partitionStatsFilePredicate = file -> true;
        } else {
            statsFilePredicate = file -> snapshotIds.contains(file.snapshotId());
            partitionStatsFilePredicate = file -> snapshotIds.contains(file.snapshotId());
        }
        table.statisticsFiles().stream().filter(statsFilePredicate).map(StatisticsFile::path).forEach(statsFileLocations::add);
        table.partitionStatisticsFiles().stream().filter(partitionStatsFilePredicate).map(PartitionStatisticsFile::path).forEach(statsFileLocations::add);
        return statsFileLocations;
    }
}

