/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.Accessor;
import com.dataiku.dss.shadelib.org.apache.iceberg.Accessors;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.BiMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableBiMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.primitives.Ints;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Schema
implements Serializable {
    private static final Joiner NEWLINE = Joiner.on('\n');
    private static final String ALL_COLUMNS = "*";
    private static final int DEFAULT_SCHEMA_ID = 0;
    @VisibleForTesting
    static final int DEFAULT_VALUES_MIN_FORMAT_VERSION = 3;
    @VisibleForTesting
    static final Map<Type.TypeID, Integer> MIN_FORMAT_VERSIONS = ImmutableMap.of(Type.TypeID.TIMESTAMP_NANO, 3, Type.TypeID.VARIANT, 3, Type.TypeID.UNKNOWN, 3, Type.TypeID.GEOMETRY, 3, Type.TypeID.GEOGRAPHY, 3);
    private final Types.StructType struct;
    private final int schemaId;
    private final int[] identifierFieldIds;
    private final int highestFieldId;
    private transient BiMap<String, Integer> aliasToId = null;
    private transient Map<Integer, Types.NestedField> idToField = null;
    private transient Map<String, Integer> nameToId = null;
    private transient Map<String, Integer> lowerCaseNameToId = null;
    private transient Map<Integer, Accessor<StructLike>> idToAccessor = null;
    private transient Map<Integer, String> idToName = null;
    private transient Set<Integer> identifierFieldIdSet = null;
    private final transient Map<Integer, Integer> idsToReassigned;
    private final transient Map<Integer, Integer> idsToOriginal;

    public Schema(List<Types.NestedField> columns, Map<String, Integer> aliases) {
        this(columns, aliases, ImmutableSet.of());
    }

    public Schema(List<Types.NestedField> columns, Map<String, Integer> aliases, Set<Integer> identifierFieldIds) {
        this(0, columns, aliases, identifierFieldIds);
    }

    public Schema(List<Types.NestedField> columns) {
        this(columns, ImmutableSet.of());
    }

    public Schema(List<Types.NestedField> columns, Set<Integer> identifierFieldIds) {
        this(0, columns, identifierFieldIds);
    }

    public Schema(List<Types.NestedField> columns, Set<Integer> identifierFieldIds, TypeUtil.GetID getId) {
        this(0, columns, identifierFieldIds, getId);
    }

    public Schema(int schemaId, List<Types.NestedField> columns) {
        this(schemaId, columns, ImmutableSet.of());
    }

    public Schema(int schemaId, List<Types.NestedField> columns, Set<Integer> identifierFieldIds) {
        this(schemaId, columns, null, identifierFieldIds, null);
    }

    public Schema(int schemaId, List<Types.NestedField> columns, Set<Integer> identifierFieldIds, TypeUtil.GetID getId) {
        this(schemaId, columns, null, identifierFieldIds, getId);
    }

    public Schema(int schemaId, List<Types.NestedField> columns, Map<String, Integer> aliases, Set<Integer> identifierFieldIds) {
        this(schemaId, columns, aliases, identifierFieldIds, null);
    }

    public Schema(int schemaId, List<Types.NestedField> columns, Map<String, Integer> aliases, Set<Integer> identifierFieldIds, TypeUtil.GetID getID) {
        this.schemaId = schemaId;
        this.idsToOriginal = Maps.newHashMap();
        this.idsToReassigned = Maps.newHashMap();
        List<Types.NestedField> finalColumns = this.reassignIds(columns, getID);
        this.struct = Types.StructType.of(finalColumns);
        BiMap<String, Integer> biMap = this.aliasToId = aliases != null ? ImmutableBiMap.copyOf(aliases) : null;
        if (identifierFieldIds != null) {
            Map<Integer, Integer> idToParent = TypeUtil.indexParents(this.struct);
            identifierFieldIds.forEach(id -> Schema.validateIdentifierField(id, this.lazyIdToField(), idToParent));
        }
        this.identifierFieldIds = identifierFieldIds != null ? Ints.toArray(identifierFieldIds) : new int[]{};
        this.highestFieldId = this.lazyIdToName().keySet().stream().mapToInt(i -> i).max().orElse(0);
    }

    static void validateIdentifierField(int fieldId, Map<Integer, Types.NestedField> idToField, Map<Integer, Integer> idToParent) {
        Types.NestedField field = idToField.get(fieldId);
        Preconditions.checkArgument(field != null, "Cannot add fieldId %s as an identifier field: field does not exist", fieldId);
        Preconditions.checkArgument(field.type().isPrimitiveType(), "Cannot add field %s as an identifier field: not a primitive type field", (Object)field.name());
        Preconditions.checkArgument(field.isRequired(), "Cannot add field %s as an identifier field: not a required field", (Object)field.name());
        Preconditions.checkArgument(!Types.DoubleType.get().equals(field.type()) && !Types.FloatType.get().equals(field.type()), "Cannot add field %s as an identifier field: must not be float or double field", (Object)field.name());
        Integer parentId = idToParent.get(field.fieldId());
        LinkedList<Integer> deque = Lists.newLinkedList();
        while (parentId != null) {
            deque.push(parentId);
            parentId = idToParent.get(parentId);
        }
        while (!deque.isEmpty()) {
            Types.NestedField parent = idToField.get(deque.pop());
            Preconditions.checkArgument(parent.type().isStructType(), "Cannot add field %s as an identifier field: must not be nested in %s", (Object)field.name(), (Object)parent);
            Preconditions.checkArgument(parent.isRequired(), "Cannot add field %s as an identifier field: must not be nested in an optional field %s", (Object)field.name(), (Object)parent);
        }
    }

    public Schema(Types.NestedField ... columns) {
        this(0, Arrays.asList(columns));
    }

    public Schema(int schemaId, Types.NestedField ... columns) {
        this(schemaId, Arrays.asList(columns));
    }

    private Map<Integer, Types.NestedField> lazyIdToField() {
        if (this.idToField == null) {
            this.idToField = TypeUtil.indexById(this.struct);
        }
        return this.idToField;
    }

    private Map<String, Integer> lazyNameToId() {
        if (this.nameToId == null) {
            this.nameToId = ImmutableMap.copyOf(TypeUtil.indexByName(this.struct));
        }
        return this.nameToId;
    }

    private Map<Integer, String> lazyIdToName() {
        if (this.idToName == null) {
            this.idToName = ImmutableMap.copyOf(TypeUtil.indexNameById(this.struct));
        }
        return this.idToName;
    }

    private Map<String, Integer> lazyLowerCaseNameToId() {
        if (this.lowerCaseNameToId == null) {
            this.lowerCaseNameToId = ImmutableMap.copyOf(TypeUtil.indexByLowerCaseName(this.struct));
        }
        return this.lowerCaseNameToId;
    }

    private Map<Integer, Accessor<StructLike>> lazyIdToAccessor() {
        if (this.idToAccessor == null) {
            this.idToAccessor = Accessors.forSchema(this);
        }
        return this.idToAccessor;
    }

    private Set<Integer> lazyIdentifierFieldIdSet() {
        if (this.identifierFieldIdSet == null) {
            this.identifierFieldIdSet = ImmutableSet.copyOf(Ints.asList(this.identifierFieldIds));
        }
        return this.identifierFieldIdSet;
    }

    public int schemaId() {
        return this.schemaId;
    }

    public int highestFieldId() {
        return this.highestFieldId;
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    public Map<Integer, String> idToName() {
        return this.lazyIdToName();
    }

    public Types.StructType asStruct() {
        return this.struct;
    }

    public List<Types.NestedField> columns() {
        return this.struct.fields();
    }

    public Set<Integer> identifierFieldIds() {
        return this.lazyIdentifierFieldIdSet();
    }

    public Set<String> identifierFieldNames() {
        return this.identifierFieldIds().stream().map(id -> this.lazyIdToName().get(id)).collect(Collectors.toSet());
    }

    public Type findType(String name) {
        Preconditions.checkArgument(!name.isEmpty(), "Invalid column name: (empty)");
        Integer id = this.lazyNameToId().get(name);
        if (id != null) {
            return this.findType(id);
        }
        return null;
    }

    public Type findType(int id) {
        Types.NestedField field = this.lazyIdToField().get(id);
        if (field != null) {
            return field.type();
        }
        return null;
    }

    public Types.NestedField findField(int id) {
        return this.lazyIdToField().get(id);
    }

    public Types.NestedField findField(String name) {
        Preconditions.checkArgument(!name.isEmpty(), "Invalid column name: (empty)");
        Integer id = this.lazyNameToId().get(name);
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public Types.NestedField caseInsensitiveFindField(String name) {
        Preconditions.checkArgument(!name.isEmpty(), "Invalid column name: (empty)");
        Integer id = this.lazyLowerCaseNameToId().get(name.toLowerCase(Locale.ROOT));
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public String findColumnName(int id) {
        return this.lazyIdToName().get(id);
    }

    public Integer aliasToId(String alias) {
        if (this.aliasToId != null) {
            return (Integer)this.aliasToId.get(alias);
        }
        return null;
    }

    public String idToAlias(Integer fieldId) {
        if (this.aliasToId != null) {
            return (String)this.aliasToId.inverse().get(fieldId);
        }
        return null;
    }

    public Accessor<StructLike> accessorForField(int id) {
        return this.lazyIdToAccessor().get(id);
    }

    public Schema select(String ... names) {
        return this.select(Arrays.asList(names));
    }

    public Schema select(Collection<String> names) {
        return this.internalSelect(names, true);
    }

    public Schema caseInsensitiveSelect(String ... names) {
        return this.caseInsensitiveSelect(Arrays.asList(names));
    }

    public Schema caseInsensitiveSelect(Collection<String> names) {
        return this.internalSelect(names, false);
    }

    public boolean sameSchema(Schema anotherSchema) {
        return this.asStruct().equals(anotherSchema.asStruct()) && this.identifierFieldIds().equals(anotherSchema.identifierFieldIds());
    }

    private Schema internalSelect(Collection<String> names, boolean caseSensitive) {
        if (names.contains(ALL_COLUMNS)) {
            return this;
        }
        HashSet<Integer> selected = Sets.newHashSet();
        for (String name : names) {
            Integer id = caseSensitive ? this.lazyNameToId().get(name) : this.lazyLowerCaseNameToId().get(name.toLowerCase(Locale.ROOT));
            if (id == null) continue;
            selected.add(id);
        }
        return TypeUtil.select(this, selected);
    }

    private String identifierFieldToString(Types.NestedField field) {
        return "  " + String.valueOf(field) + (this.identifierFieldIds().contains(field.fieldId()) ? " (id)" : "");
    }

    public String toString() {
        return String.format("table {\n%s\n}", NEWLINE.join(this.struct.fields().stream().map(this::identifierFieldToString).collect(Collectors.toList())));
    }

    public Map<Integer, Integer> idsToReassigned() {
        return this.idsToReassigned != null ? this.idsToReassigned : Collections.emptyMap();
    }

    public Map<Integer, Integer> idsToOriginal() {
        return this.idsToOriginal != null ? this.idsToOriginal : Collections.emptyMap();
    }

    private List<Types.NestedField> reassignIds(List<Types.NestedField> columns, TypeUtil.GetID getID) {
        if (getID == null) {
            return columns;
        }
        Type res = TypeUtil.assignIds(Types.StructType.of(columns), oldId -> {
            int newId = getID.get(oldId);
            if (newId != oldId) {
                this.idsToReassigned.put(oldId, newId);
                this.idsToOriginal.put(newId, oldId);
            }
            return newId;
        });
        return res.asStructType().fields();
    }

    public static void checkCompatibility(Schema schema, int formatVersion) {
        TreeMap<Integer, String> problems = Maps.newTreeMap();
        for (Types.NestedField field : schema.lazyIdToField().values()) {
            Integer minFormatVersion = MIN_FORMAT_VERSIONS.get((Object)field.type().typeId());
            if (minFormatVersion != null && formatVersion < minFormatVersion) {
                problems.put(field.fieldId(), String.format("Invalid type for %s: %s is not supported until v%s", schema.findColumnName(field.fieldId()), field.type(), minFormatVersion));
            }
            if (field.initialDefault() == null || formatVersion >= 3) continue;
            problems.put(field.fieldId(), String.format("Invalid initial default for %s: non-null default (%s) is not supported until v%s", schema.findColumnName(field.fieldId()), field.initialDefault(), 3));
        }
        if (!problems.isEmpty()) {
            throw new IllegalStateException(String.format("Invalid schema for v%s:\n- %s", formatVersion, Joiner.on("\n- ").join(problems.values())));
        }
    }
}

