/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitFailedException;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;

public class SetLocation
implements UpdateLocation {
    private final TableOperations ops;
    private String newLocation;

    public SetLocation(TableOperations ops) {
        this.ops = ops;
        this.newLocation = null;
    }

    @Override
    public UpdateLocation setLocation(String location) {
        this.newLocation = location;
        return this;
    }

    @Override
    public String apply() {
        return this.newLocation;
    }

    @Override
    public void commit() {
        TableMetadata base = this.ops.refresh();
        Tasks.foreach(this.ops).retry(base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(base.propertyAsInt("commit.retry.min-wait-ms", 100), base.propertyAsInt("commit.retry.max-wait-ms", 60000), base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> taskOps.commit(base, base.updateLocation(this.newLocation)));
    }
}

