/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.EnvironmentContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTaskGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.events.Listeners;
import com.dataiku.dss.shadelib.org.apache.iceberg.events.ScanEvent;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.DefaultMetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.ImmutableScanReport;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.ScanMetrics;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.ScanMetricsResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.Timer;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SnapshotUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnapshotScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
extends BaseScan<ThisT, T, G> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotScan.class);
    private ScanMetrics scanMetrics;

    protected SnapshotScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    protected Long snapshotId() {
        return this.context().snapshotId();
    }

    protected abstract CloseableIterable<T> doPlanFiles();

    protected boolean useSnapshotSchema() {
        return false;
    }

    protected ScanMetrics scanMetrics() {
        if (this.scanMetrics == null) {
            this.scanMetrics = ScanMetrics.of(new DefaultMetricsContext());
        }
        return this.scanMetrics;
    }

    public ThisT useSnapshot(long scanSnapshotId) {
        Preconditions.checkArgument(this.snapshotId() == null, "Cannot override snapshot, already set snapshot id=%s", (Object)this.snapshotId());
        Preconditions.checkArgument(this.table().snapshot(scanSnapshotId) != null, "Cannot find snapshot with ID %s", scanSnapshotId);
        Schema newSchema = this.useSnapshotSchema() ? SnapshotUtil.schemaFor(this.table(), scanSnapshotId) : this.tableSchema();
        TableScanContext newContext = this.context().useSnapshotId(scanSnapshotId);
        return this.newRefinedScan(this.table(), newSchema, newContext);
    }

    public ThisT useRef(String name) {
        if ("main".equals(name)) {
            return this.newRefinedScan(this.table(), this.tableSchema(), this.context());
        }
        Preconditions.checkArgument(this.snapshotId() == null, "Cannot override ref, already set snapshot id=%s", (Object)this.snapshotId());
        Snapshot snapshot = this.table().snapshot(name);
        Preconditions.checkArgument(snapshot != null, "Cannot find ref %s", (Object)name);
        TableScanContext newContext = this.context().useSnapshotId(snapshot.snapshotId());
        return this.newRefinedScan(this.table(), SnapshotUtil.schemaFor(this.table(), name), newContext);
    }

    public ThisT asOfTime(long timestampMillis) {
        Preconditions.checkArgument(this.snapshotId() == null, "Cannot override snapshot, already set snapshot id=%s", (Object)this.snapshotId());
        return this.useSnapshot(SnapshotUtil.snapshotIdAsOfTime(this.table(), timestampMillis));
    }

    @Override
    public CloseableIterable<T> planFiles() {
        Snapshot snapshot = this.snapshot();
        if (snapshot == null) {
            LOG.info("Scanning empty table {}", (Object)this.table());
            return CloseableIterable.empty();
        }
        LOG.info("Scanning table {} snapshot {} created at {} with filter {}", new Object[]{this.table(), snapshot.snapshotId(), DateTimeUtil.formatTimestampMillis(snapshot.timestampMillis()), ExpressionUtil.toSanitizedString(this.filter())});
        Listeners.notifyAll(new ScanEvent(this.table().name(), snapshot.snapshotId(), this.filter(), this.schema()));
        ArrayList<Integer> projectedFieldIds = Lists.newArrayList(TypeUtil.getProjectedIds(this.schema()));
        List projectedFieldNames = projectedFieldIds.stream().map(this.schema()::findColumnName).collect(Collectors.toList());
        Timer.Timed planningDuration = this.scanMetrics().totalPlanningDuration().start();
        return CloseableIterable.whenComplete(this.doPlanFiles(), () -> {
            planningDuration.stop();
            HashMap<String, String> metadata = Maps.newHashMap(this.context().options());
            metadata.putAll(EnvironmentContext.get());
            ImmutableScanReport scanReport = ImmutableScanReport.builder().schemaId(this.schema().schemaId()).projectedFieldIds(projectedFieldIds).projectedFieldNames(projectedFieldNames).tableName(this.table().name()).snapshotId(snapshot.snapshotId()).filter(ExpressionUtil.sanitize(this.schema().asStruct(), this.filter(), this.context().caseSensitive())).scanMetrics(ScanMetricsResult.fromScanMetrics(this.scanMetrics())).metadata(metadata).build();
            this.context().metricsReporter().report(scanReport);
        });
    }

    public Snapshot snapshot() {
        return this.snapshotId() != null ? this.table().snapshot(this.snapshotId()) : this.table().currentSnapshot();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table()).add("projection", this.schema().asStruct()).add("filter", this.filter()).add("ignoreResiduals", this.shouldIgnoreResiduals()).add("caseSensitive", this.isCaseSensitive()).toString();
    }
}

