/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.NullOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortDirection;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import java.io.Serializable;
import java.util.Objects;

public class SortField
implements Serializable {
    private final Transform<?, ?> transform;
    private final int sourceId;
    private final SortDirection direction;
    private final NullOrder nullOrder;

    SortField(Transform<?, ?> transform, int sourceId, SortDirection direction, NullOrder nullOrder) {
        this.transform = transform;
        this.sourceId = sourceId;
        this.direction = direction;
        this.nullOrder = nullOrder;
    }

    public <S, T> Transform<S, T> transform() {
        return this.transform;
    }

    public int sourceId() {
        return this.sourceId;
    }

    public SortDirection direction() {
        return this.direction;
    }

    public NullOrder nullOrder() {
        return this.nullOrder;
    }

    public boolean satisfies(SortField other) {
        if (Objects.equals(this, other)) {
            return true;
        }
        if (this.sourceId != other.sourceId || this.direction != other.direction || this.nullOrder != other.nullOrder) {
            return false;
        }
        return this.transform.satisfiesOrderOf(other.transform);
    }

    public String toString() {
        return String.valueOf(this.transform) + "(" + this.sourceId + ") " + String.valueOf((Object)this.direction) + " " + String.valueOf((Object)this.nullOrder);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SortField that = (SortField)other;
        return this.transform.toString().equals(that.transform.toString()) && this.sourceId == that.sourceId && this.direction == that.direction && this.nullOrder == that.nullOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transform, this.sourceId, this.direction, this.nullOrder});
    }
}

