/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.AppendFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.BatchScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.BatchScanAdapter;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.ExpireSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.HistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalAppendScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalChangelogScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManageSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.OverwriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ReplacePartitions;
import com.dataiku.dss.shadelib.org.apache.iceberg.ReplaceSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteManifests;
import com.dataiku.dss.shadelib.org.apache.iceberg.RowDelta;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotRef;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.StatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.Transaction;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdatePartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdatePartitionStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateProperties;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateSchema;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.LocationProvider;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface Table {
    default public String name() {
        return this.toString();
    }

    public void refresh();

    public TableScan newScan();

    default public BatchScan newBatchScan() {
        return new BatchScanAdapter(this.newScan());
    }

    default public IncrementalAppendScan newIncrementalAppendScan() {
        throw new UnsupportedOperationException("Incremental append scan is not supported");
    }

    default public IncrementalChangelogScan newIncrementalChangelogScan() {
        throw new UnsupportedOperationException("Incremental changelog scan is not supported");
    }

    public Schema schema();

    public Map<Integer, Schema> schemas();

    public PartitionSpec spec();

    public Map<Integer, PartitionSpec> specs();

    public SortOrder sortOrder();

    public Map<Integer, SortOrder> sortOrders();

    public Map<String, String> properties();

    public String location();

    public Snapshot currentSnapshot();

    public Snapshot snapshot(long var1);

    public Iterable<Snapshot> snapshots();

    public List<HistoryEntry> history();

    public UpdateSchema updateSchema();

    public UpdatePartitionSpec updateSpec();

    public UpdateProperties updateProperties();

    public ReplaceSortOrder replaceSortOrder();

    public UpdateLocation updateLocation();

    public AppendFiles newAppend();

    default public AppendFiles newFastAppend() {
        return this.newAppend();
    }

    public RewriteFiles newRewrite();

    public RewriteManifests rewriteManifests();

    public OverwriteFiles newOverwrite();

    public RowDelta newRowDelta();

    public ReplacePartitions newReplacePartitions();

    public DeleteFiles newDelete();

    default public UpdateStatistics updateStatistics() {
        throw new UnsupportedOperationException("Updating statistics is not supported by " + this.getClass().getName());
    }

    default public UpdatePartitionStatistics updatePartitionStatistics() {
        throw new UnsupportedOperationException("Updating partition statistics is not supported by " + this.getClass().getName());
    }

    public ExpireSnapshots expireSnapshots();

    public ManageSnapshots manageSnapshots();

    public Transaction newTransaction();

    public FileIO io();

    public EncryptionManager encryption();

    public LocationProvider locationProvider();

    public List<StatisticsFile> statisticsFiles();

    default public List<PartitionStatisticsFile> partitionStatisticsFiles() {
        return ImmutableList.of();
    }

    public Map<String, SnapshotRef> refs();

    default public UUID uuid() {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't implement uuid");
    }

    default public Snapshot snapshot(String name) {
        SnapshotRef ref = this.refs().get(name);
        if (ref != null) {
            return this.snapshot(ref.snapshotId());
        }
        return null;
    }
}

