/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.HasTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.SerializableTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class TableUtil {
    private TableUtil() {
    }

    public static int formatVersion(Table table) {
        Preconditions.checkArgument(null != table, "Invalid table: null");
        if (table instanceof SerializableTable) {
            SerializableTable serializableTable = (SerializableTable)table;
            return serializableTable.formatVersion();
        }
        if (table instanceof HasTableOperations) {
            HasTableOperations ops = (HasTableOperations)((Object)table);
            return ops.operations().current().formatVersion();
        }
        if (table instanceof BaseMetadataTable) {
            BaseMetadataTable metadataTable = (BaseMetadataTable)table;
            return metadataTable.table().operations().current().formatVersion();
        }
        throw new IllegalArgumentException(String.format("%s does not have a format version", table.getClass().getSimpleName()));
    }

    public static String metadataFileLocation(Table table) {
        Preconditions.checkArgument(null != table, "Invalid table: null");
        if (table instanceof SerializableTable) {
            SerializableTable serializableTable = (SerializableTable)table;
            return serializableTable.metadataFileLocation();
        }
        if (table instanceof HasTableOperations) {
            HasTableOperations ops = (HasTableOperations)((Object)table);
            return ops.operations().current().metadataFileLocation();
        }
        if (table instanceof BaseMetadataTable) {
            return ((BaseMetadataTable)table).table().operations().current().metadataFileLocation();
        }
        throw new IllegalArgumentException(String.format("%s does not have a metadata file location", table.getClass().getSimpleName()));
    }

    public static boolean supportsRowLineage(Table table) {
        Preconditions.checkArgument(null != table, "Invalid table: null");
        if (table instanceof BaseMetadataTable) {
            return false;
        }
        return TableUtil.formatVersion(table) >= 3;
    }
}

