/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.NullOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortDirection;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transforms;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import java.util.Collections;
import java.util.List;

public class UnboundSortOrder {
    private static final UnboundSortOrder UNSORTED_ORDER = new UnboundSortOrder(0, Collections.emptyList());
    private final int orderId;
    private final List<UnboundSortField> fields;

    private UnboundSortOrder(int orderId, List<UnboundSortField> fields) {
        this.orderId = orderId;
        this.fields = fields;
    }

    public SortOrder bind(Schema schema) {
        SortOrder.Builder builder = SortOrder.builderFor(schema).withOrderId(this.orderId);
        for (UnboundSortField field : this.fields) {
            Type sourceType = schema.findType(field.sourceId);
            Transform<?, ?> transform = sourceType != null ? Transforms.fromString(sourceType, field.transform.toString()) : field.transform;
            builder.addSortField(transform, field.sourceId, field.direction, field.nullOrder);
        }
        return builder.build();
    }

    SortOrder bindUnchecked(Schema schema) {
        SortOrder.Builder builder = SortOrder.builderFor(schema).withOrderId(this.orderId);
        for (UnboundSortField field : this.fields) {
            builder.addSortField(field.transform, field.sourceId, field.direction, field.nullOrder);
        }
        return builder.buildUnchecked();
    }

    int orderId() {
        return this.orderId;
    }

    List<UnboundSortField> fields() {
        return this.fields;
    }

    static Builder builder() {
        return new Builder();
    }

    static class UnboundSortField {
        private final Transform<?, ?> transform;
        private final int sourceId;
        private final SortDirection direction;
        private final NullOrder nullOrder;

        private UnboundSortField(String transformAsString, int sourceId, SortDirection direction, NullOrder nullOrder) {
            this.transform = Transforms.fromString(transformAsString);
            this.sourceId = sourceId;
            this.direction = direction;
            this.nullOrder = nullOrder;
        }

        public String transformAsString() {
            return this.transform.toString();
        }

        public int sourceId() {
            return this.sourceId;
        }

        public SortDirection direction() {
            return this.direction;
        }

        public NullOrder nullOrder() {
            return this.nullOrder;
        }
    }

    static class Builder {
        private final List<UnboundSortField> fields = Lists.newArrayList();
        private Integer orderId = null;

        private Builder() {
        }

        Builder withOrderId(int newOrderId) {
            this.orderId = newOrderId;
            return this;
        }

        Builder addSortField(String transformAsString, int sourceId, SortDirection direction, NullOrder nullOrder) {
            this.fields.add(new UnboundSortField(transformAsString, sourceId, direction, nullOrder));
            return this;
        }

        UnboundSortOrder build() {
            if (this.fields.isEmpty()) {
                if (this.orderId != null && this.orderId != 0) {
                    throw new IllegalArgumentException("Unsorted order ID must be 0");
                }
                return UNSORTED_ORDER;
            }
            if (this.orderId != null && this.orderId == 0) {
                throw new IllegalArgumentException("Sort order ID 0 is reserved for unsorted order");
            }
            int actualOrderId = this.orderId != null ? this.orderId : 1;
            return new UnboundSortOrder(actualOrderId, this.fields);
        }
    }
}

