/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;

class V1Metadata {
    static final Schema MANIFEST_LIST_SCHEMA = new Schema(ManifestFile.PATH, ManifestFile.LENGTH, ManifestFile.SPEC_ID, ManifestFile.SNAPSHOT_ID, ManifestFile.ADDED_FILES_COUNT, ManifestFile.EXISTING_FILES_COUNT, ManifestFile.DELETED_FILES_COUNT, ManifestFile.PARTITION_SUMMARIES, ManifestFile.ADDED_ROWS_COUNT, ManifestFile.EXISTING_ROWS_COUNT, ManifestFile.DELETED_ROWS_COUNT, ManifestFile.KEY_METADATA);
    private static final Types.NestedField BLOCK_SIZE = Types.NestedField.required(105, "block_size_in_bytes", Types.LongType.get());

    private V1Metadata() {
    }

    static Schema entrySchema(Types.StructType partitionType) {
        return V1Metadata.wrapFileSchema(V1Metadata.dataFileSchema(partitionType));
    }

    static Schema wrapFileSchema(Types.StructType fileSchema) {
        return new Schema(ManifestEntry.STATUS, ManifestEntry.SNAPSHOT_ID, Types.NestedField.required(2, "data_file", fileSchema));
    }

    static Types.StructType dataFileSchema(Types.StructType partitionType) {
        return Types.StructType.of(DataFile.FILE_PATH, DataFile.FILE_FORMAT, Types.NestedField.required(102, "partition", partitionType), DataFile.RECORD_COUNT, DataFile.FILE_SIZE, BLOCK_SIZE, DataFile.COLUMN_SIZES, DataFile.VALUE_COUNTS, DataFile.NULL_VALUE_COUNTS, DataFile.NAN_VALUE_COUNTS, DataFile.LOWER_BOUNDS, DataFile.UPPER_BOUNDS, DataFile.KEY_METADATA, DataFile.SPLIT_OFFSETS, DataFile.SORT_ORDER_ID);
    }

    static class DataFileWrapper
    implements DataFile,
    StructLike {
        private static final long DEFAULT_BLOCK_SIZE = 0x4000000L;
        private final int size = V1Metadata.dataFileSchema(Types.StructType.of(new Types.NestedField[0])).fields().size();
        private DataFile wrapped = null;

        DataFileWrapper() {
        }

        DataFileWrapper wrap(DataFile file) {
            this.wrapped = file;
            return this;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify DataFileWrapper wrapper via set");
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.location();
                }
                case 1: {
                    return this.wrapped.format() != null ? this.wrapped.format().toString() : null;
                }
                case 2: {
                    return this.wrapped.partition();
                }
                case 3: {
                    return this.wrapped.recordCount();
                }
                case 4: {
                    return this.wrapped.fileSizeInBytes();
                }
                case 5: {
                    return 0x4000000L;
                }
                case 6: {
                    return this.wrapped.columnSizes();
                }
                case 7: {
                    return this.wrapped.valueCounts();
                }
                case 8: {
                    return this.wrapped.nullValueCounts();
                }
                case 9: {
                    return this.wrapped.nanValueCounts();
                }
                case 10: {
                    return this.wrapped.lowerBounds();
                }
                case 11: {
                    return this.wrapped.upperBounds();
                }
                case 12: {
                    return this.wrapped.keyMetadata();
                }
                case 13: {
                    return this.wrapped.splitOffsets();
                }
                case 14: {
                    return this.wrapped.sortOrderId();
                }
            }
            throw new IllegalArgumentException("Unknown field ordinal: " + pos);
        }

        @Override
        public Long pos() {
            return null;
        }

        @Override
        public String manifestLocation() {
            return null;
        }

        @Override
        public int specId() {
            return this.wrapped.specId();
        }

        @Override
        public FileContent content() {
            return this.wrapped.content();
        }

        @Override
        public CharSequence path() {
            return this.wrapped.location();
        }

        @Override
        public FileFormat format() {
            return this.wrapped.format();
        }

        @Override
        public StructLike partition() {
            return this.wrapped.partition();
        }

        @Override
        public long recordCount() {
            return this.wrapped.recordCount();
        }

        @Override
        public long fileSizeInBytes() {
            return this.wrapped.fileSizeInBytes();
        }

        @Override
        public Map<Integer, Long> columnSizes() {
            return this.wrapped.columnSizes();
        }

        @Override
        public Map<Integer, Long> valueCounts() {
            return this.wrapped.valueCounts();
        }

        @Override
        public Map<Integer, Long> nullValueCounts() {
            return this.wrapped.nullValueCounts();
        }

        @Override
        public Map<Integer, Long> nanValueCounts() {
            return this.wrapped.nanValueCounts();
        }

        @Override
        public Map<Integer, ByteBuffer> lowerBounds() {
            return this.wrapped.lowerBounds();
        }

        @Override
        public Map<Integer, ByteBuffer> upperBounds() {
            return this.wrapped.upperBounds();
        }

        @Override
        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        @Override
        public List<Long> splitOffsets() {
            return this.wrapped.splitOffsets();
        }

        @Override
        public Integer sortOrderId() {
            return this.wrapped.sortOrderId();
        }

        @Override
        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        @Override
        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        @Override
        public DataFile copy() {
            return (DataFile)this.wrapped.copy();
        }

        @Override
        public DataFile copyWithStats(Set<Integer> requestedColumnIds) {
            return (DataFile)this.wrapped.copyWithStats(requestedColumnIds);
        }

        @Override
        public DataFile copyWithoutStats() {
            return (DataFile)this.wrapped.copyWithoutStats();
        }
    }

    static class ManifestEntryWrapper
    implements ManifestEntry<DataFile>,
    StructLike {
        private final int size = V1Metadata.entrySchema(Types.StructType.of(new Types.NestedField[0])).columns().size();
        private final DataFileWrapper fileWrapper = new DataFileWrapper();
        private ManifestEntry<DataFile> wrapped = null;

        ManifestEntryWrapper() {
        }

        public ManifestEntryWrapper wrap(ManifestEntry<DataFile> entry) {
            this.wrapped = entry;
            return this;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify ManifestEntryWrapper wrapper via set");
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.status().id();
                }
                case 1: {
                    return this.wrapped.snapshotId();
                }
                case 2: {
                    DataFile file = this.wrapped.file();
                    if (file != null) {
                        return this.fileWrapper.wrap(file);
                    }
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        @Override
        public ManifestEntry.Status status() {
            return this.wrapped.status();
        }

        @Override
        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        @Override
        public void setSnapshotId(long snapshotId) {
            this.wrapped.setSnapshotId(snapshotId);
        }

        @Override
        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        @Override
        public void setDataSequenceNumber(long dataSequenceNumber) {
            this.wrapped.setDataSequenceNumber(dataSequenceNumber);
        }

        @Override
        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        @Override
        public void setFileSequenceNumber(long fileSequenceNumber) {
            this.wrapped.setFileSequenceNumber(fileSequenceNumber);
        }

        @Override
        public DataFile file() {
            return this.wrapped.file();
        }

        @Override
        public ManifestEntry<DataFile> copy() {
            return this.wrapped.copy();
        }

        @Override
        public ManifestEntry<DataFile> copyWithoutStats() {
            return this.wrapped.copyWithoutStats();
        }
    }

    static class ManifestFileWrapper
    implements ManifestFile,
    StructLike {
        private ManifestFile wrapped = null;

        ManifestFileWrapper() {
        }

        public ManifestFile wrap(ManifestFile file) {
            this.wrapped = file;
            return this;
        }

        @Override
        public int size() {
            return MANIFEST_LIST_SCHEMA.columns().size();
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify ManifestFileWrapper wrapper via set");
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return this.length();
                }
                case 2: {
                    return this.partitionSpecId();
                }
                case 3: {
                    return this.snapshotId();
                }
                case 4: {
                    return this.addedFilesCount();
                }
                case 5: {
                    return this.existingFilesCount();
                }
                case 6: {
                    return this.deletedFilesCount();
                }
                case 7: {
                    return this.partitions();
                }
                case 8: {
                    return this.addedRowsCount();
                }
                case 9: {
                    return this.existingRowsCount();
                }
                case 10: {
                    return this.deletedRowsCount();
                }
                case 11: {
                    return this.keyMetadata();
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        @Override
        public String path() {
            return this.wrapped.path();
        }

        @Override
        public long length() {
            return this.wrapped.length();
        }

        @Override
        public int partitionSpecId() {
            return this.wrapped.partitionSpecId();
        }

        @Override
        public ManifestContent content() {
            return this.wrapped.content();
        }

        @Override
        public long sequenceNumber() {
            return this.wrapped.sequenceNumber();
        }

        @Override
        public long minSequenceNumber() {
            return this.wrapped.minSequenceNumber();
        }

        @Override
        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        @Override
        public boolean hasAddedFiles() {
            return this.wrapped.hasAddedFiles();
        }

        @Override
        public Integer addedFilesCount() {
            return this.wrapped.addedFilesCount();
        }

        @Override
        public Long addedRowsCount() {
            return this.wrapped.addedRowsCount();
        }

        @Override
        public boolean hasExistingFiles() {
            return this.wrapped.hasExistingFiles();
        }

        @Override
        public Integer existingFilesCount() {
            return this.wrapped.existingFilesCount();
        }

        @Override
        public Long existingRowsCount() {
            return this.wrapped.existingRowsCount();
        }

        @Override
        public boolean hasDeletedFiles() {
            return this.wrapped.hasDeletedFiles();
        }

        @Override
        public Integer deletedFilesCount() {
            return this.wrapped.deletedFilesCount();
        }

        @Override
        public Long deletedRowsCount() {
            return this.wrapped.deletedRowsCount();
        }

        @Override
        public List<ManifestFile.PartitionFieldSummary> partitions() {
            return this.wrapped.partitions();
        }

        @Override
        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        @Override
        public ManifestFile copy() {
            return this.wrapped.copy();
        }
    }
}

