/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.actions;

import com.dataiku.dss.shadelib.org.apache.iceberg.CatalogUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.BaseCommitService;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.RewritePositionDeletesGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CleanableFailure;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitStateUnknownException;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewritePositionDeletesCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(RewritePositionDeletesCommitManager.class);
    private final Table table;
    private final long startingSnapshotId;
    private final Map<String, String> snapshotProperties;

    public RewritePositionDeletesCommitManager(Table table) {
        this(table, ImmutableMap.of());
    }

    public RewritePositionDeletesCommitManager(Table table, Map<String, String> snapshotProperties) {
        this.table = table;
        this.startingSnapshotId = table.currentSnapshot().snapshotId();
        this.snapshotProperties = snapshotProperties;
    }

    public void commit(Set<RewritePositionDeletesGroup> fileGroups) {
        RewriteFiles rewriteFiles = this.table.newRewrite().validateFromSnapshot(this.startingSnapshotId);
        for (RewritePositionDeletesGroup group : fileGroups) {
            for (DeleteFile file : group.rewrittenDeleteFiles()) {
                rewriteFiles.deleteFile(file);
            }
            for (DeleteFile file : group.addedDeleteFiles()) {
                rewriteFiles.addFile(file, group.maxRewrittenDataSequenceNumber());
            }
        }
        this.snapshotProperties.forEach(rewriteFiles::set);
        rewriteFiles.commit();
    }

    public void abort(RewritePositionDeletesGroup fileGroup) {
        Preconditions.checkState(fileGroup.addedDeleteFiles() != null, "Cannot abort a fileGroup that was not rewritten");
        Iterable<String> filePaths = Iterables.transform(fileGroup.addedDeleteFiles(), ContentFile::location);
        CatalogUtil.deleteFiles(this.table.io(), filePaths, "position delete", true);
    }

    public void commitOrClean(Set<RewritePositionDeletesGroup> rewriteGroups) {
        try {
            this.commit(rewriteGroups);
        }
        catch (CommitStateUnknownException e) {
            LOG.error("Commit state unknown for {}, cannot clean up files because they may have been committed successfully.", rewriteGroups, (Object)e);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof CleanableFailure) {
                LOG.error("Cannot commit groups {}, attempting to clean up written files", rewriteGroups, (Object)e);
                rewriteGroups.forEach(this::abort);
            }
            throw e;
        }
    }

    public CommitService service(int rewritesPerCommit) {
        return new CommitService(rewritesPerCommit);
    }

    public class CommitService
    extends BaseCommitService<RewritePositionDeletesGroup> {
        CommitService(int rewritesPerCommit) {
            super(RewritePositionDeletesCommitManager.this.table, rewritesPerCommit);
        }

        @Override
        protected void commitOrClean(Set<RewritePositionDeletesGroup> batch) {
            RewritePositionDeletesCommitManager.this.commitOrClean(batch);
        }

        @Override
        protected void abortFileGroup(RewritePositionDeletesGroup group) {
            RewritePositionDeletesCommitManager.this.abort(group);
        }
    }
}

