/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.avro;

import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroWithTypeByStructureVisitor;
import com.dataiku.dss.shadelib.org.apache.iceberg.mapping.MappedField;
import com.dataiku.dss.shadelib.org.apache.iceberg.mapping.MappedFields;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;

public class NameMappingWithAvroSchema
extends AvroWithTypeByStructureVisitor<MappedFields> {
    @Override
    public MappedFields record(Type struct, Schema record, List<String> names, List<MappedFields> fieldResults) {
        ArrayList<MappedField> fields = Lists.newArrayListWithExpectedSize(fieldResults.size());
        for (int i = 0; i < fieldResults.size(); ++i) {
            Types.NestedField field = struct.asStructType().fields().get(i);
            MappedFields result = fieldResults.get(i);
            fields.add(MappedField.of((Integer)field.fieldId(), field.name(), result));
        }
        return MappedFields.of(fields);
    }

    @Override
    public MappedFields union(Type type, Schema union, List<MappedFields> optionResults) {
        if (AvroSchemaUtil.isOptionSchema(union)) {
            for (int i = 0; i < optionResults.size(); ++i) {
                if (((Schema)union.getTypes().get(i)).getType() == Schema.Type.NULL) continue;
                return optionResults.get(i);
            }
        } else {
            Preconditions.checkArgument(type instanceof Types.StructType, "Cannot visit invalid Iceberg type: %s for Avro complex union type: %s", (Object)type, (Object)union);
            Types.StructType struct = (Types.StructType)type;
            ArrayList<MappedField> fields = Lists.newArrayListWithExpectedSize(optionResults.size());
            int index = 0;
            for (Schema option : union.getTypes()) {
                if (option.getType() == Schema.Type.NULL) continue;
                if (option.getType() == Schema.Type.RECORD || option.getType() == Schema.Type.ENUM || option.getType() == Schema.Type.FIXED) {
                    fields.add(MappedField.of((Integer)struct.fields().get(index).fieldId(), option.getName(), optionResults.get(index)));
                } else {
                    fields.add(MappedField.of((Integer)struct.fields().get(index).fieldId(), option.getType().getName(), optionResults.get(index)));
                }
                ++index;
            }
            return MappedFields.of(fields);
        }
        return null;
    }

    @Override
    public MappedFields array(Type list, Schema array, MappedFields elementResult) {
        return MappedFields.of(MappedField.of((Integer)list.asListType().elementId(), "element", elementResult));
    }

    @Override
    public MappedFields map(Type sMap, Schema map, MappedFields keyResult, MappedFields valueResult) {
        return MappedFields.of(MappedField.of((Integer)sMap.asMapType().keyId(), "key", keyResult), MappedField.of((Integer)sMap.asMapType().valueId(), "value", valueResult));
    }

    @Override
    public MappedFields map(Type sMap, Schema map, MappedFields valueResult) {
        return MappedFields.of(MappedField.of((Integer)sMap.asMapType().keyId(), "key", null), MappedField.of((Integer)sMap.asMapType().valueId(), "value", valueResult));
    }

    @Override
    public MappedFields primitive(Type type, Schema primitive) {
        return null;
    }
}

