/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.catalog;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchNamespaceException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchTableException;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface SessionCatalog {
    public void initialize(String var1, Map<String, String> var2);

    public String name();

    public Map<String, String> properties();

    public List<TableIdentifier> listTables(SessionContext var1, Namespace var2);

    public Catalog.TableBuilder buildTable(SessionContext var1, TableIdentifier var2, Schema var3);

    public Table registerTable(SessionContext var1, TableIdentifier var2, String var3);

    default public boolean tableExists(SessionContext context, TableIdentifier ident) {
        try {
            this.loadTable(context, ident);
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public Table loadTable(SessionContext var1, TableIdentifier var2);

    public boolean dropTable(SessionContext var1, TableIdentifier var2);

    public boolean purgeTable(SessionContext var1, TableIdentifier var2);

    public void renameTable(SessionContext var1, TableIdentifier var2, TableIdentifier var3);

    public void invalidateTable(SessionContext var1, TableIdentifier var2);

    default public void createNamespace(SessionContext context, Namespace namespace) {
        this.createNamespace(context, namespace, ImmutableMap.of());
    }

    public void createNamespace(SessionContext var1, Namespace var2, Map<String, String> var3);

    default public List<Namespace> listNamespaces(SessionContext context) {
        return this.listNamespaces(context, Namespace.empty());
    }

    public List<Namespace> listNamespaces(SessionContext var1, Namespace var2);

    public Map<String, String> loadNamespaceMetadata(SessionContext var1, Namespace var2);

    public boolean dropNamespace(SessionContext var1, Namespace var2);

    public boolean updateNamespaceMetadata(SessionContext var1, Namespace var2, Map<String, String> var3, Set<String> var4);

    default public boolean namespaceExists(SessionContext context, Namespace namespace) {
        try {
            this.loadNamespaceMetadata(context, namespace);
            return true;
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }

    public static final class SessionContext {
        private final String sessionId;
        private final String identity;
        private final Map<String, String> credentials;
        private final Map<String, String> properties;
        private final Object wrappedIdentity;

        public static SessionContext createEmpty() {
            return new SessionContext(UUID.randomUUID().toString(), null, null, ImmutableMap.of());
        }

        public SessionContext(String sessionId, String identity, Map<String, String> credentials, Map<String, String> properties) {
            this(sessionId, identity, credentials, properties, null);
        }

        public SessionContext(String sessionId, String identity, Map<String, String> credentials, Map<String, String> properties, Object wrappedIdentity) {
            this.sessionId = sessionId;
            this.identity = identity;
            this.credentials = credentials;
            this.properties = properties;
            this.wrappedIdentity = wrappedIdentity;
        }

        public String sessionId() {
            return this.sessionId;
        }

        public String identity() {
            return this.identity;
        }

        public Map<String, String> credentials() {
            return this.credentials;
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public Object wrappedIdentity() {
            return this.wrappedIdentity;
        }
    }
}

