/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetricsConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.Avro;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.avro.DataWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.orc.GenericOrcWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet.GenericParquetWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.EqualityDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppender;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppenderFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.orc.ORC;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.Parquet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public class GenericAppenderFactory
implements FileAppenderFactory<Record> {
    private final Table table;
    private final Schema schema;
    private final PartitionSpec spec;
    private final int[] equalityFieldIds;
    private final Schema eqDeleteRowSchema;
    private final Schema posDeleteRowSchema;
    private final Map<String, String> config;

    public GenericAppenderFactory(Schema schema) {
        this(schema, PartitionSpec.unpartitioned());
    }

    public GenericAppenderFactory(Schema schema, PartitionSpec spec) {
        this(schema, spec, null, null, null);
    }

    public GenericAppenderFactory(Schema schema, PartitionSpec spec, int[] equalityFieldIds, Schema eqDeleteRowSchema, Schema posDeleteRowSchema) {
        this(null, schema, spec, null, equalityFieldIds, eqDeleteRowSchema, posDeleteRowSchema);
    }

    public GenericAppenderFactory(Table table, Schema schema, PartitionSpec spec, Map<String, String> config, int[] equalityFieldIds, Schema eqDeleteRowSchema, Schema posDeleteRowSchema) {
        this.table = table;
        Map<Object, Object> map = this.config = config == null ? Maps.newHashMap() : config;
        if (table != null) {
            this.schema = schema == null ? table.schema() : schema;
            this.spec = spec == null ? table.spec() : spec;
            this.validateMetricsConfig(this.config);
        } else {
            this.schema = schema;
            this.spec = spec;
        }
        this.equalityFieldIds = equalityFieldIds;
        this.eqDeleteRowSchema = eqDeleteRowSchema;
        this.posDeleteRowSchema = posDeleteRowSchema;
    }

    public GenericAppenderFactory set(String property, String value) {
        this.validateMetricsConfig(ImmutableMap.of(property, value));
        this.config.put(property, value);
        return this;
    }

    public GenericAppenderFactory setAll(Map<String, String> properties) {
        this.validateMetricsConfig(properties);
        this.config.putAll(properties);
        return this;
    }

    @Override
    public FileAppender<Record> newAppender(OutputFile outputFile, FileFormat fileFormat) {
        return this.newAppender(EncryptionUtil.plainAsEncryptedOutput(outputFile), fileFormat);
    }

    @Override
    public FileAppender<Record> newAppender(EncryptedOutputFile encryptedOutputFile, FileFormat fileFormat) {
        MetricsConfig metricsConfig = this.table != null ? MetricsConfig.forTable(this.table) : MetricsConfig.fromProperties(this.config);
        try {
            switch (fileFormat) {
                case AVRO: {
                    return Avro.write(encryptedOutputFile).schema(this.schema).createWriterFunc(DataWriter::create).metricsConfig(metricsConfig).setAll(this.config).overwrite().build();
                }
                case PARQUET: {
                    return Parquet.write(encryptedOutputFile).schema(this.schema).createWriterFunc(GenericParquetWriter::create).setAll(this.config).metricsConfig(metricsConfig).overwrite().build();
                }
                case ORC: {
                    return ORC.write((EncryptedOutputFile)encryptedOutputFile).schema(this.schema).createWriterFunc(GenericOrcWriter::buildWriter).setAll(this.config).metricsConfig(metricsConfig).overwrite().build();
                }
            }
            throw new UnsupportedOperationException("Cannot write unknown file format: " + String.valueOf((Object)fileFormat));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriter<Record> newDataWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        return new com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriter<Record>(this.newAppender(file, format), format, file.encryptingOutputFile().location(), this.spec, partition, file.keyMetadata());
    }

    @Override
    public EqualityDeleteWriter<Record> newEqDeleteWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        Preconditions.checkState(this.equalityFieldIds != null && this.equalityFieldIds.length > 0, "Equality field ids shouldn't be null or empty when creating equality-delete writer");
        Preconditions.checkNotNull(this.eqDeleteRowSchema, "Equality delete row schema shouldn't be null when creating equality-delete writer");
        MetricsConfig metricsConfig = this.table != null ? MetricsConfig.forTable(this.table) : MetricsConfig.fromProperties(this.config);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.writeDeletes(file).createWriterFunc(DataWriter::create).withPartition(partition).overwrite().setAll(this.config).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
                case ORC: {
                    return ORC.writeDeletes((EncryptedOutputFile)file).createWriterFunc(GenericOrcWriter::buildWriter).withPartition(partition).overwrite().setAll(this.config).metricsConfig(metricsConfig).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
                case PARQUET: {
                    return Parquet.writeDeletes(file).createWriterFunc(GenericParquetWriter::create).withPartition(partition).overwrite().setAll(this.config).metricsConfig(metricsConfig).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write equality-deletes for unsupported file format: " + String.valueOf((Object)format));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PositionDeleteWriter<Record> newPosDeleteWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        MetricsConfig metricsConfig = this.table != null ? MetricsConfig.forPositionDelete(this.table) : MetricsConfig.fromProperties(this.config);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.writeDeletes(file).createWriterFunc(DataWriter::create).withPartition(partition).overwrite().setAll(this.config).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).buildPositionWriter();
                }
                case ORC: {
                    return ORC.writeDeletes((EncryptedOutputFile)file).createWriterFunc(GenericOrcWriter::buildWriter).withPartition(partition).overwrite().setAll(this.config).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).buildPositionWriter();
                }
                case PARQUET: {
                    return Parquet.writeDeletes(file).createWriterFunc(GenericParquetWriter::create).withPartition(partition).overwrite().setAll(this.config).metricsConfig(metricsConfig).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).buildPositionWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write pos-deletes for unsupported file format: " + String.valueOf((Object)format));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void validateMetricsConfig(Map<String, String> writeConfig) {
        if (this.table == null) {
            return;
        }
        if (writeConfig.keySet().stream().anyMatch(k -> k.startsWith("write.metadata.metrics."))) {
            throw new IllegalArgumentException("Cannot set metrics properties when the table is provided, use table properties instead");
        }
    }
}

