/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import java.nio.ByteBuffer;

public class GenericDataUtil {
    private GenericDataUtil() {
    }

    public static Object internalToGeneric(Type type, Object value) {
        if (null == value) {
            return null;
        }
        switch (type.typeId()) {
            case DATE: {
                return DateTimeUtil.dateFromDays((Integer)value);
            }
            case TIME: {
                return DateTimeUtil.timeFromMicros((Long)value);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return DateTimeUtil.timestamptzFromMicros((Long)value);
                }
                return DateTimeUtil.timestampFromMicros((Long)value);
            }
            case FIXED: {
                return ByteBuffers.toByteArray((ByteBuffer)value);
            }
        }
        return value;
    }
}

