/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.CombinedScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataColumns;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.Avro;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.GenericDeleteFilter;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.IdentityPartitionConverters;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.InternalRecordWrapper;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.avro.PlannedDataReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.orc.GenericOrcReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet.GenericParquetReaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Evaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.orc.ORC;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.Parquet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PartitionUtil;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.orc.TypeDescription;

class GenericReader
implements Serializable {
    private final FileIO io;
    private final Schema tableSchema;
    private final Schema projection;
    private final boolean caseSensitive;
    private final boolean reuseContainers;

    GenericReader(TableScan scan, boolean reuseContainers) {
        this.io = scan.table().io();
        this.tableSchema = scan.table().schema();
        this.projection = scan.schema();
        this.caseSensitive = scan.isCaseSensitive();
        this.reuseContainers = reuseContainers;
    }

    CloseableIterator<Record> open(CloseableIterable<CombinedScanTask> tasks) {
        Iterable fileTasks = Iterables.concat(Iterables.transform(tasks, CombinedScanTask::files));
        return CloseableIterable.concat(Iterables.transform(fileTasks, this::open)).iterator();
    }

    public CloseableIterable<Record> open(CombinedScanTask task) {
        return new CombinedTaskIterable(task);
    }

    public CloseableIterable<Record> open(FileScanTask task) {
        GenericDeleteFilter deletes = new GenericDeleteFilter(this.io, task, this.tableSchema, this.projection);
        Schema readSchema = deletes.requiredSchema();
        CloseableIterable<Record> records = this.openFile(task, readSchema);
        records = deletes.filter(records);
        records = this.applyResidual(records, readSchema, task.residual());
        return records;
    }

    private CloseableIterable<Record> applyResidual(CloseableIterable<Record> records, Schema recordSchema, Expression residual) {
        if (residual != null && residual != Expressions.alwaysTrue()) {
            InternalRecordWrapper wrapper = new InternalRecordWrapper(recordSchema.asStruct());
            Evaluator filter = new Evaluator(recordSchema.asStruct(), residual, this.caseSensitive);
            return CloseableIterable.filter(records, record -> filter.eval(wrapper.wrap((StructLike)record)));
        }
        return records;
    }

    private CloseableIterable<Record> openFile(FileScanTask task, Schema fileProjection) {
        InputFile input = this.io.newInputFile((DataFile)task.file());
        Map<Integer, ?> partition = PartitionUtil.constantsMap(task, IdentityPartitionConverters::convertConstant);
        switch (((DataFile)task.file()).format()) {
            case AVRO: {
                Avro.ReadBuilder avro = Avro.read(input).project(fileProjection).createResolvingReader(schema -> PlannedDataReader.create(schema, partition)).split(task.start(), task.length());
                if (this.reuseContainers) {
                    avro.reuseContainers();
                }
                return avro.build();
            }
            case PARQUET: {
                Parquet.ReadBuilder parquet = Parquet.read(input).project(fileProjection).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(fileProjection, fileSchema, partition)).split(task.start(), task.length()).caseSensitive(this.caseSensitive).filter(task.residual());
                if (this.reuseContainers) {
                    parquet.reuseContainers();
                }
                return parquet.build();
            }
            case ORC: {
                Schema projectionWithoutConstantAndMetadataFields = TypeUtil.selectNot(fileProjection, Sets.union(partition.keySet(), MetadataColumns.metadataFieldIds()));
                ORC.ReadBuilder orc = ORC.read((InputFile)input).project(projectionWithoutConstantAndMetadataFields).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)fileProjection, (TypeDescription)fileSchema, (Map)partition)).split(task.start(), task.length()).caseSensitive(this.caseSensitive).filter(task.residual());
                return orc.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", ((DataFile)task.file()).format().name(), ((DataFile)task.file()).location()));
    }

    private class CombinedTaskIterable
    extends CloseableGroup
    implements CloseableIterable<Record> {
        private final CombinedScanTask task;

        private CombinedTaskIterable(CombinedScanTask task) {
            this.task = task;
        }

        @Override
        public CloseableIterator<Record> iterator() {
            Iterator iter = CloseableIterable.concat(Iterables.transform(this.task.files(), GenericReader.this::open)).iterator();
            this.addCloseable((Closeable)((Object)iter));
            return iter;
        }
    }
}

