/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet.BaseParquetWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetValueWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetValueWriters;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ColumnDescriptor;
import com.dataiku.dss.shadelib.org.apache.parquet.io.api.Binary;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.LogicalTypeAnnotation;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.MessageType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class GenericParquetWriter
extends BaseParquetWriter<Record> {
    private static final GenericParquetWriter INSTANCE = new GenericParquetWriter();
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericParquetWriter() {
    }

    public static ParquetValueWriter<Record> create(Schema schema, MessageType type) {
        return INSTANCE.createWriter(schema.asStruct(), type);
    }

    @Override
    protected ParquetValueWriters.StructWriter<Record> createStructWriter(Types.StructType struct, List<ParquetValueWriter<?>> writers) {
        return ParquetValueWriters.recordWriter(struct, writers);
    }

    @Override
    protected ParquetValueWriter<?> fixedWriter(ColumnDescriptor desc) {
        return new FixedWriter(desc);
    }

    @Override
    protected ParquetValueWriter<?> dateWriter(ColumnDescriptor desc) {
        return new DateWriter(desc);
    }

    @Override
    protected ParquetValueWriter<?> timeWriter(ColumnDescriptor desc) {
        return new TimeWriter(desc);
    }

    @Override
    protected ParquetValueWriter<?> timestampWriter(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        LogicalTypeAnnotation timestamp = desc.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument(timestamp instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation, "Invalid timestamp logical type: " + String.valueOf(timestamp));
        LogicalTypeAnnotation.TimeUnit unit = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)timestamp).getUnit();
        if (isAdjustedToUTC) {
            return new TimestamptzWriter(desc, GenericParquetWriter.fromParquet(unit));
        }
        return new TimestampWriter(desc, GenericParquetWriter.fromParquet(unit));
    }

    private static ChronoUnit fromParquet(LogicalTypeAnnotation.TimeUnit unit) {
        switch (unit) {
            case MICROS: {
                return ChronoUnit.MICROS;
            }
            case NANOS: {
                return ChronoUnit.NANOS;
            }
        }
        throw new UnsupportedOperationException("Unsupported unit for timestamp: " + String.valueOf((Object)unit));
    }

    private static class FixedWriter
    extends ParquetValueWriters.PrimitiveWriter<byte[]> {
        private final int length;

        FixedWriter(ColumnDescriptor desc) {
            super(desc);
            this.length = desc.getPrimitiveType().getTypeLength();
        }

        @Override
        public void write(int repetitionLevel, byte[] value) {
            Preconditions.checkArgument(value.length == this.length, "Cannot write byte buffer of length %s as fixed[%s]", value.length, this.length);
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray(value));
        }
    }

    private static class DateWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDate> {
        DateWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, LocalDate value) {
            this.column.writeInteger(repetitionLevel, (int)ChronoUnit.DAYS.between(EPOCH_DAY, value));
        }
    }

    private static class TimeWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalTime> {
        TimeWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, LocalTime value) {
            this.column.writeLong(repetitionLevel, value.toNanoOfDay() / 1000L);
        }
    }

    private static class TimestamptzWriter
    extends ParquetValueWriters.PrimitiveWriter<OffsetDateTime> {
        private final ChronoUnit unit;

        TimestamptzWriter(ColumnDescriptor desc, ChronoUnit unit) {
            super(desc);
            this.unit = unit;
        }

        @Override
        public void write(int repetitionLevel, OffsetDateTime value) {
            this.column.writeLong(repetitionLevel, this.unit.between(EPOCH, value));
        }
    }

    private static class TimestampWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDateTime> {
        private final ChronoUnit unit;

        TimestampWriter(ColumnDescriptor desc, ChronoUnit unit) {
            super(desc);
            this.unit = unit;
        }

        @Override
        public void write(int repetitionLevel, LocalDateTime value) {
            this.column.writeLong(repetitionLevel, this.unit.between(EPOCH, value.atOffset(ZoneOffset.UTC)));
        }
    }
}

