/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.AesGcmInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.AesGcmOutputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.PositionOutputStream;

public class AesGcmOutputFile
implements OutputFile {
    private final OutputFile targetFile;
    private final byte[] dataKey;
    private final byte[] fileAADPrefix;

    public AesGcmOutputFile(OutputFile targetFile, byte[] dataKey, byte[] fileAADPrefix) {
        this.targetFile = targetFile;
        this.dataKey = dataKey;
        this.fileAADPrefix = fileAADPrefix;
    }

    @Override
    public PositionOutputStream create() {
        return new AesGcmOutputStream(this.targetFile.create(), this.dataKey, this.fileAADPrefix);
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        return new AesGcmOutputStream(this.targetFile.createOrOverwrite(), this.dataKey, this.fileAADPrefix);
    }

    @Override
    public String location() {
        return this.targetFile.location();
    }

    @Override
    public InputFile toInputFile() {
        return new AesGcmInputFile(this.targetFile.toInputFile(), this.dataKey, this.fileAADPrefix);
    }
}

