/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import java.nio.ByteBuffer;

class BaseEncryptionKeyMetadata
implements EncryptionKeyMetadata {
    private final ByteBuffer keyMetadata;

    public static EncryptionKeyMetadata fromKeyMetadata(ByteBuffer keyMetadata) {
        if (keyMetadata == null) {
            return EncryptionKeyMetadata.empty();
        }
        return new BaseEncryptionKeyMetadata(keyMetadata);
    }

    public static EncryptionKeyMetadata fromByteArray(byte[] keyMetadata) {
        if (keyMetadata == null) {
            return EncryptionKeyMetadata.empty();
        }
        return BaseEncryptionKeyMetadata.fromKeyMetadata(ByteBuffer.wrap(keyMetadata));
    }

    private BaseEncryptionKeyMetadata(ByteBuffer keyMetadata) {
        this.keyMetadata = keyMetadata;
    }

    @Override
    public ByteBuffer buffer() {
        return this.keyMetadata;
    }

    @Override
    public EncryptionKeyMetadata copy() {
        return new BaseEncryptionKeyMetadata(ByteBuffers.copy(this.keyMetadata));
    }
}

