/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.BaseEncryptedInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.BaseEncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.BaseEncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import java.nio.ByteBuffer;

public class EncryptedFiles {
    public static EncryptedInputFile encryptedInput(InputFile encryptedInputFile, EncryptionKeyMetadata keyMetadata) {
        return new BaseEncryptedInputFile(encryptedInputFile, keyMetadata);
    }

    public static EncryptedInputFile encryptedInput(InputFile encryptedInputFile, ByteBuffer keyMetadata) {
        return EncryptedFiles.encryptedInput(encryptedInputFile, BaseEncryptionKeyMetadata.fromKeyMetadata(keyMetadata));
    }

    public static EncryptedInputFile encryptedInput(InputFile encryptedInputFile, byte[] keyMetadata) {
        return EncryptedFiles.encryptedInput(encryptedInputFile, BaseEncryptionKeyMetadata.fromByteArray(keyMetadata));
    }

    public static EncryptedOutputFile encryptedOutput(OutputFile encryptingOutputFile, EncryptionKeyMetadata keyMetadata) {
        return new BaseEncryptedOutputFile(encryptingOutputFile, keyMetadata);
    }

    public static EncryptedOutputFile encryptedOutput(OutputFile encryptingOutputFile, ByteBuffer keyMetadata) {
        return EncryptedFiles.encryptedOutput(encryptingOutputFile, BaseEncryptionKeyMetadata.fromKeyMetadata(keyMetadata));
    }

    public static EncryptedOutputFile encryptedOutput(OutputFile encryptedOutputFile, byte[] keyMetadata) {
        return EncryptedFiles.encryptedOutput(encryptedOutputFile, BaseEncryptionKeyMetadata.fromByteArray(keyMetadata));
    }

    public static EncryptedOutputFile plainAsEncryptedOutput(OutputFile encryptingOutputFile) {
        return new BaseEncryptedOutputFile(encryptingOutputFile, EncryptionKeyMetadata.EMPTY);
    }

    private EncryptedFiles() {
    }
}

