/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.AesGcmInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.AesGcmOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.KeyManagementClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.NativeEncryptionInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.NativeEncryptionOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.StandardKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

public class StandardEncryptionManager
implements EncryptionManager {
    private final transient KeyManagementClient kmsClient;
    private final String tableKeyId;
    private final int dataKeyLength;
    private volatile transient SecureRandom lazyRNG = null;

    public StandardEncryptionManager(String tableKeyId, int dataKeyLength, KeyManagementClient kmsClient) {
        Preconditions.checkNotNull(tableKeyId, "Invalid encryption key ID: null");
        Preconditions.checkArgument(dataKeyLength == 16 || dataKeyLength == 24 || dataKeyLength == 32, "Invalid data key length: %s (must be 16, 24, or 32)", dataKeyLength);
        Preconditions.checkNotNull(kmsClient, "Invalid KMS client: null");
        this.tableKeyId = tableKeyId;
        this.kmsClient = kmsClient;
        this.dataKeyLength = dataKeyLength;
    }

    @Override
    public NativeEncryptionOutputFile encrypt(OutputFile plainOutput) {
        return new StandardEncryptedOutputFile(plainOutput, this.dataKeyLength);
    }

    @Override
    public NativeEncryptionInputFile decrypt(EncryptedInputFile encrypted) {
        if (encrypted instanceof NativeEncryptionInputFile) {
            return (NativeEncryptionInputFile)encrypted;
        }
        return new StandardDecryptedInputFile(encrypted);
    }

    @Override
    public Iterable<InputFile> decrypt(Iterable<EncryptedInputFile> encrypted) {
        return Iterables.transform(encrypted, this::decrypt);
    }

    private SecureRandom workerRNG() {
        if (this.lazyRNG == null) {
            this.lazyRNG = new SecureRandom();
        }
        return this.lazyRNG;
    }

    public ByteBuffer wrapKey(ByteBuffer secretKey) {
        if (this.kmsClient == null) {
            throw new IllegalStateException("Cannot wrap key after called after serialization (missing KMS client)");
        }
        return this.kmsClient.wrapKey(secretKey, this.tableKeyId);
    }

    public ByteBuffer unwrapKey(ByteBuffer wrappedSecretKey) {
        if (this.kmsClient == null) {
            throw new IllegalStateException("Cannot wrap key after called after serialization (missing KMS client)");
        }
        return this.kmsClient.unwrapKey(wrappedSecretKey, this.tableKeyId);
    }

    private class StandardEncryptedOutputFile
    implements NativeEncryptionOutputFile {
        private final OutputFile plainOutputFile;
        private final int dataKeyLength;
        private StandardKeyMetadata lazyKeyMetadata = null;
        private OutputFile lazyEncryptingOutputFile = null;

        StandardEncryptedOutputFile(OutputFile plainOutputFile, int dataKeyLength) {
            this.plainOutputFile = plainOutputFile;
            this.dataKeyLength = dataKeyLength;
        }

        @Override
        public StandardKeyMetadata keyMetadata() {
            if (null == this.lazyKeyMetadata) {
                byte[] fileDek = new byte[this.dataKeyLength];
                StandardEncryptionManager.this.workerRNG().nextBytes(fileDek);
                byte[] aadPrefix = new byte[16];
                StandardEncryptionManager.this.workerRNG().nextBytes(aadPrefix);
                this.lazyKeyMetadata = new StandardKeyMetadata(fileDek, aadPrefix);
            }
            return this.lazyKeyMetadata;
        }

        @Override
        public OutputFile encryptingOutputFile() {
            if (null == this.lazyEncryptingOutputFile) {
                this.lazyEncryptingOutputFile = new AesGcmOutputFile(this.plainOutputFile, ByteBuffers.toByteArray(this.keyMetadata().encryptionKey()), ByteBuffers.toByteArray(this.keyMetadata().aadPrefix()));
            }
            return this.lazyEncryptingOutputFile;
        }

        @Override
        public OutputFile plainOutputFile() {
            return this.plainOutputFile;
        }
    }

    private static class StandardDecryptedInputFile
    implements NativeEncryptionInputFile {
        private final EncryptedInputFile encryptedInputFile;
        private StandardKeyMetadata lazyKeyMetadata = null;
        private AesGcmInputFile lazyDecryptedInputFile = null;

        private StandardDecryptedInputFile(EncryptedInputFile encryptedInputFile) {
            this.encryptedInputFile = encryptedInputFile;
        }

        @Override
        public InputFile encryptedInputFile() {
            return this.encryptedInputFile.encryptedInputFile();
        }

        @Override
        public StandardKeyMetadata keyMetadata() {
            if (null == this.lazyKeyMetadata) {
                this.lazyKeyMetadata = StandardKeyMetadata.castOrParse(this.encryptedInputFile.keyMetadata());
            }
            return this.lazyKeyMetadata;
        }

        private AesGcmInputFile decrypted() {
            if (null == this.lazyDecryptedInputFile) {
                this.lazyDecryptedInputFile = new AesGcmInputFile(this.encryptedInputFile.encryptedInputFile(), ByteBuffers.toByteArray(this.keyMetadata().encryptionKey()), ByteBuffers.toByteArray(this.keyMetadata().aadPrefix()));
            }
            return this.lazyDecryptedInputFile;
        }

        @Override
        public long getLength() {
            return this.decrypted().getLength();
        }

        @Override
        public SeekableInputStream newStream() {
            return this.decrypted().newStream();
        }

        @Override
        public String location() {
            return this.decrypted().location();
        }

        @Override
        public boolean exists() {
            return this.decrypted().exists();
        }
    }
}

