/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.events;

import com.dataiku.dss.shadelib.org.apache.iceberg.events.Listener;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Listeners {
    private static final Map<Class<?>, Queue<Listener<?>>> LISTENERS = Maps.newConcurrentMap();

    private Listeners() {
    }

    public static <E> void register(Listener<E> listener, Class<E> eventType) {
        Queue list = LISTENERS.computeIfAbsent(eventType, k -> new ConcurrentLinkedQueue());
        list.add(listener);
    }

    public static <E> void notifyAll(E event) {
        Preconditions.checkNotNull(event, "Cannot notify listeners for a null event.");
        Queue<Listener<?>> list = LISTENERS.get(event.getClass());
        if (list != null) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Listener value;
                Listener listener = value = (Listener)iterator2.next();
                listener.notify(event);
            }
        }
    }
}

