/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.PathUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;

public class BoundExtract<T>
implements BoundTerm<T> {
    private final BoundReference<?> ref;
    private final String path;
    private final Type type;

    BoundExtract(BoundReference<?> ref, String path, Type type) {
        this.ref = ref;
        this.path = PathUtil.toNormalizedPath(PathUtil.parse(path));
        this.type = type;
    }

    @Override
    public BoundReference<?> ref() {
        return this.ref;
    }

    public String path() {
        return this.path;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isEquivalentTo(BoundTerm<?> other) {
        if (other instanceof BoundExtract) {
            BoundExtract that = (BoundExtract)other;
            return this.ref.isEquivalentTo(that.ref) && this.path.equals(that.path) && this.type.equals(that.type);
        }
        return false;
    }

    @Override
    public T eval(StructLike struct) {
        throw new UnsupportedOperationException("Cannot evaluate " + String.valueOf(this));
    }

    public String toString() {
        return "extract(" + String.valueOf(this.ref) + ", path=" + this.path + ", type=" + String.valueOf(this.type) + ")";
    }
}

